/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.s3.analyticsaccelerator.util;

import lombok.Generated;
import lombok.NonNull;
import software.amazon.s3.analyticsaccelerator.util.S3URI;

public class ObjectKey {
    @NonNull
    S3URI s3URI;
    @NonNull
    String etag;

    public final boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ObjectKey objectKey = (ObjectKey)o;
        return this.s3URI.equals(objectKey.s3URI) && this.etag.equals(objectKey.etag);
    }

    public int hashCode() {
        return this.s3URI.hashCode() + this.etag.hashCode();
    }

    @Generated
    public static ObjectKeyBuilder builder() {
        return new ObjectKeyBuilder();
    }

    @NonNull
    @Generated
    public S3URI getS3URI() {
        return this.s3URI;
    }

    @NonNull
    @Generated
    public String getEtag() {
        return this.etag;
    }

    @Generated
    public ObjectKey(@NonNull S3URI s3URI, @NonNull String etag) {
        if (s3URI == null) {
            throw new NullPointerException("s3URI is marked non-null but is null");
        }
        if (etag == null) {
            throw new NullPointerException("etag is marked non-null but is null");
        }
        this.s3URI = s3URI;
        this.etag = etag;
    }

    @Generated
    public static class ObjectKeyBuilder {
        @Generated
        private S3URI s3URI;
        @Generated
        private String etag;

        @Generated
        ObjectKeyBuilder() {
        }

        @Generated
        public ObjectKeyBuilder s3URI(@NonNull S3URI s3URI) {
            if (s3URI == null) {
                throw new NullPointerException("s3URI is marked non-null but is null");
            }
            this.s3URI = s3URI;
            return this;
        }

        @Generated
        public ObjectKeyBuilder etag(@NonNull String etag) {
            if (etag == null) {
                throw new NullPointerException("etag is marked non-null but is null");
            }
            this.etag = etag;
            return this;
        }

        @Generated
        public ObjectKey build() {
            return new ObjectKey(this.s3URI, this.etag);
        }

        @Generated
        public String toString() {
            return "ObjectKey.ObjectKeyBuilder(s3URI=" + this.s3URI + ", etag=" + this.etag + ")";
        }
    }
}

