/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.api.impl.pb;

import java.util.ArrayList;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.thirdparty.protobuf.ProtocolStringList;
import org.apache.hadoop.yarn.proto.YarnServerNodemanagerRecoveryProtos;
import org.apache.hadoop.yarn.server.nodemanager.DeletionService;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.deletion.recovery.DeletionTaskRecoveryInfo;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.deletion.task.DeletionTask;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.deletion.task.DeletionTaskType;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.deletion.task.DockerContainerDeletionTask;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.deletion.task.FileDeletionTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class NMProtoUtils {
    private static final Logger LOG = LoggerFactory.getLogger(NMProtoUtils.class);

    private NMProtoUtils() {
    }

    public static DeletionTask convertProtoToDeletionTask(YarnServerNodemanagerRecoveryProtos.DeletionServiceDeleteTaskProto proto, DeletionService deletionService) {
        int taskId = proto.getId();
        if (proto.hasTaskType() && proto.getTaskType() != null) {
            if (proto.getTaskType().equals(DeletionTaskType.FILE.name())) {
                LOG.debug("Converting recovered FileDeletionTask");
                return NMProtoUtils.convertProtoToFileDeletionTask(proto, deletionService, taskId);
            }
            if (proto.getTaskType().equals(DeletionTaskType.DOCKER_CONTAINER.name())) {
                LOG.debug("Converting recovered DockerContainerDeletionTask");
                return NMProtoUtils.convertProtoToDockerContainerDeletionTask(proto, deletionService, taskId);
            }
        }
        LOG.debug("Unable to get task type, trying FileDeletionTask");
        return NMProtoUtils.convertProtoToFileDeletionTask(proto, deletionService, taskId);
    }

    public static FileDeletionTask convertProtoToFileDeletionTask(YarnServerNodemanagerRecoveryProtos.DeletionServiceDeleteTaskProto proto, DeletionService deletionService, int taskId) {
        String user = proto.hasUser() ? proto.getUser() : null;
        Path subdir = null;
        if (proto.hasSubdir()) {
            subdir = new Path(proto.getSubdir());
        }
        ArrayList<Path> basePaths = null;
        ProtocolStringList basedirs = proto.getBasedirsList();
        if (basedirs != null && basedirs.size() > 0) {
            basePaths = new ArrayList<Path>(basedirs.size());
            for (String basedir : basedirs) {
                basePaths.add(new Path(basedir));
            }
        }
        return new FileDeletionTask(taskId, deletionService, user, subdir, basePaths);
    }

    public static DockerContainerDeletionTask convertProtoToDockerContainerDeletionTask(YarnServerNodemanagerRecoveryProtos.DeletionServiceDeleteTaskProto proto, DeletionService deletionService, int taskId) {
        String user = proto.hasUser() ? proto.getUser() : null;
        String containerId = proto.hasDockerContainerId() ? proto.getDockerContainerId() : null;
        return new DockerContainerDeletionTask(taskId, deletionService, user, containerId);
    }

    public static DeletionTaskRecoveryInfo convertProtoToDeletionTaskRecoveryInfo(YarnServerNodemanagerRecoveryProtos.DeletionServiceDeleteTaskProto proto, DeletionService deletionService) {
        DeletionTask deletionTask = NMProtoUtils.convertProtoToDeletionTask(proto, deletionService);
        ArrayList<Integer> successorTaskIds = new ArrayList();
        if (proto.getSuccessorIdsList() != null && !proto.getSuccessorIdsList().isEmpty()) {
            successorTaskIds = proto.getSuccessorIdsList();
        }
        long deletionTimestamp = proto.getDeletionTime();
        return new DeletionTaskRecoveryInfo(deletionTask, successorTaskIds, deletionTimestamp);
    }
}

