/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ha;

import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ha.BadFencingConfigurationException;
import org.apache.hadoop.ha.DummyHAService;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.ha.HAServiceTarget;
import org.apache.hadoop.ha.NodeFencer;
import org.apache.hadoop.ha.ShellCommandFencer;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.util.StringUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;

public class TestShellCommandFencer {
    private ShellCommandFencer fencer = TestShellCommandFencer.createFencer();
    private static final HAServiceTarget TEST_TARGET = new DummyHAService(HAServiceProtocol.HAServiceState.ACTIVE, new InetSocketAddress("dummyhost", 1234));
    private static final Logger LOG = ShellCommandFencer.LOG;

    @BeforeClass
    public static void setupLogMock() {
        ShellCommandFencer.LOG = (Logger)Mockito.mock(Logger.class, (Answer)new LogAnswer());
    }

    @AfterClass
    public static void tearDownLogMock() throws Exception {
        ShellCommandFencer.LOG = LOG;
    }

    @Before
    public void resetLogSpy() {
        Mockito.reset((Object[])new Logger[]{ShellCommandFencer.LOG});
    }

    private static ShellCommandFencer createFencer() {
        Configuration conf = new Configuration();
        conf.set("in.fencing.tests", "yessir");
        ShellCommandFencer fencer = new ShellCommandFencer();
        fencer.setConf(conf);
        return fencer;
    }

    @Test
    public void testBasicSuccessFailure() {
        Assert.assertTrue((boolean)this.fencer.tryFence(TEST_TARGET, "echo"));
        Assert.assertFalse((boolean)this.fencer.tryFence(TEST_TARGET, "exit 1"));
        Assert.assertFalse((boolean)this.fencer.tryFence(TEST_TARGET, "xxxxxxxxxxxx"));
    }

    @Test
    public void testCheckNoArgs() {
        try {
            Configuration conf = new Configuration();
            new NodeFencer(conf, "shell");
            Assert.fail((String)"Didn't throw when passing no args to shell");
        }
        catch (BadFencingConfigurationException confe) {
            Assert.assertTrue((String)("Unexpected exception:" + StringUtils.stringifyException((Throwable)confe)), (boolean)confe.getMessage().contains("No argument passed"));
        }
    }

    @Test
    public void testCheckParensNoArgs() {
        try {
            Configuration conf = new Configuration();
            new NodeFencer(conf, "shell()");
            Assert.fail((String)"Didn't throw when passing no args to shell");
        }
        catch (BadFencingConfigurationException confe) {
            Assert.assertTrue((String)("Unexpected exception:" + StringUtils.stringifyException((Throwable)confe)), (boolean)confe.getMessage().contains("Unable to parse line: 'shell()'"));
        }
    }

    @Test
    public void testStdoutLogging() {
        Assert.assertTrue((boolean)this.fencer.tryFence(TEST_TARGET, "echo hello"));
        ((Logger)Mockito.verify((Object)ShellCommandFencer.LOG)).info(Mockito.endsWith((String)"echo hello: hello"));
    }

    @Test
    public void testStderrLogging() {
        Assert.assertTrue((boolean)this.fencer.tryFence(TEST_TARGET, "echo hello>&2"));
        ((Logger)Mockito.verify((Object)ShellCommandFencer.LOG)).warn(Mockito.endsWith((String)"echo hello>&2: hello"));
    }

    @Test
    public void testConfAsEnvironment() {
        if (!Shell.WINDOWS) {
            this.fencer.tryFence(TEST_TARGET, "echo $in_fencing_tests");
            ((Logger)Mockito.verify((Object)ShellCommandFencer.LOG)).info(Mockito.endsWith((String)"echo $in...ing_tests: yessir"));
        } else {
            this.fencer.tryFence(TEST_TARGET, "echo %in_fencing_tests%");
            ((Logger)Mockito.verify((Object)ShellCommandFencer.LOG)).info(Mockito.endsWith((String)"echo %in...ng_tests%: yessir"));
        }
    }

    @Test
    public void testTargetAsEnvironment() {
        if (!Shell.WINDOWS) {
            this.fencer.tryFence(TEST_TARGET, "echo $target_host $target_port");
            ((Logger)Mockito.verify((Object)ShellCommandFencer.LOG)).info(Mockito.endsWith((String)"echo $ta...rget_port: dummyhost 1234"));
        } else {
            this.fencer.tryFence(TEST_TARGET, "echo %target_host% %target_port%");
            ((Logger)Mockito.verify((Object)ShellCommandFencer.LOG)).info(Mockito.endsWith((String)"echo %ta...get_port%: dummyhost 1234"));
        }
    }

    @Test
    public void testEnvironmentWithPeer() {
        DummyHAService target = new DummyHAService(HAServiceProtocol.HAServiceState.ACTIVE, new InetSocketAddress("dummytarget", 1111));
        DummyHAService source = new DummyHAService(HAServiceProtocol.HAServiceState.STANDBY, new InetSocketAddress("dummysource", 2222));
        target.setTransitionTargetHAStatus(HAServiceProtocol.HAServiceState.ACTIVE);
        source.setTransitionTargetHAStatus(HAServiceProtocol.HAServiceState.STANDBY);
        String cmd = "echo $target_host $target_port,echo $source_host $source_port";
        if (!Shell.WINDOWS) {
            this.fencer.tryFence((HAServiceTarget)target, cmd);
            ((Logger)Mockito.verify((Object)ShellCommandFencer.LOG)).info(Mockito.contains((String)"echo $ta...rget_port: dummytarget 1111"));
            this.fencer.tryFence((HAServiceTarget)source, cmd);
            ((Logger)Mockito.verify((Object)ShellCommandFencer.LOG)).info(Mockito.contains((String)"echo $so...urce_port: dummysource 2222"));
        } else {
            this.fencer.tryFence((HAServiceTarget)target, cmd);
            ((Logger)Mockito.verify((Object)ShellCommandFencer.LOG)).info(Mockito.contains((String)"echo %ta...get_port%: dummytarget 1111"));
            this.fencer.tryFence((HAServiceTarget)source, cmd);
            ((Logger)Mockito.verify((Object)ShellCommandFencer.LOG)).info(Mockito.contains((String)"echo %so...urce_port%: dummysource 2222"));
        }
    }

    @Test(timeout=10000L)
    public void testSubprocessInputIsClosed() {
        Assert.assertFalse((boolean)this.fencer.tryFence(TEST_TARGET, "read"));
    }

    @Test
    public void testCommandAbbreviation() {
        Assert.assertEquals((Object)"a...f", (Object)ShellCommandFencer.abbreviate((String)"abcdef", (int)5));
        Assert.assertEquals((Object)"abcdef", (Object)ShellCommandFencer.abbreviate((String)"abcdef", (int)6));
        Assert.assertEquals((Object)"abcdef", (Object)ShellCommandFencer.abbreviate((String)"abcdef", (int)7));
        Assert.assertEquals((Object)"a...g", (Object)ShellCommandFencer.abbreviate((String)"abcdefg", (int)5));
        Assert.assertEquals((Object)"a...h", (Object)ShellCommandFencer.abbreviate((String)"abcdefgh", (int)5));
        Assert.assertEquals((Object)"a...gh", (Object)ShellCommandFencer.abbreviate((String)"abcdefgh", (int)6));
        Assert.assertEquals((Object)"ab...gh", (Object)ShellCommandFencer.abbreviate((String)"abcdefgh", (int)7));
    }

    private static class LogAnswer
    implements Answer {
        private static final List<String> DELEGATE_METHODS = Arrays.asList("error", "warn", "info", "debug", "trace");

        private LogAnswer() {
        }

        public Object answer(InvocationOnMock invocation) {
            String methodName = invocation.getMethod().getName();
            if (!DELEGATE_METHODS.contains(methodName)) {
                return null;
            }
            try {
                String msg = invocation.getArguments()[0].toString();
                Method delegateMethod = LOG.getClass().getMethod(methodName, msg.getClass());
                delegateMethod.invoke((Object)LOG, msg);
            }
            catch (Throwable e) {
                throw new IllegalStateException("Unsupported delegate method: " + methodName);
            }
            return null;
        }
    }
}

