/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.impl.streams;

import java.util.Objects;
import java.util.concurrent.ExecutorService;
import org.apache.hadoop.fs.LocalDirAllocator;
import org.apache.hadoop.fs.s3a.S3AReadOpContext;
import org.apache.hadoop.fs.s3a.S3ObjectAttributes;
import org.apache.hadoop.fs.s3a.auth.delegation.EncryptionSecrets;
import org.apache.hadoop.fs.s3a.impl.streams.ObjectInputStreamCallbacks;
import org.apache.hadoop.fs.s3a.statistics.S3AInputStreamStatistics;
import org.apache.hadoop.fs.store.audit.AuditSpan;

public final class ObjectReadParameters {
    private S3AReadOpContext context;
    private S3ObjectAttributes objectAttributes;
    private ObjectInputStreamCallbacks callbacks;
    private S3AInputStreamStatistics streamStatistics;
    private ExecutorService boundedThreadPool;
    private LocalDirAllocator directoryAllocator;
    private EncryptionSecrets encryptionSecrets;
    private AuditSpan auditSpan;

    public EncryptionSecrets getEncryptionSecrets() {
        return this.encryptionSecrets;
    }

    public ObjectReadParameters withEncryptionSecrets(EncryptionSecrets value) {
        this.encryptionSecrets = value;
        return this;
    }

    public S3AReadOpContext getContext() {
        return this.context;
    }

    public ObjectReadParameters withContext(S3AReadOpContext value) {
        this.context = value;
        return this;
    }

    public S3ObjectAttributes getObjectAttributes() {
        return this.objectAttributes;
    }

    public ObjectReadParameters withObjectAttributes(S3ObjectAttributes value) {
        this.objectAttributes = value;
        return this;
    }

    public ObjectInputStreamCallbacks getCallbacks() {
        return this.callbacks;
    }

    public ObjectReadParameters withCallbacks(ObjectInputStreamCallbacks value) {
        this.callbacks = value;
        return this;
    }

    public S3AInputStreamStatistics getStreamStatistics() {
        return this.streamStatistics;
    }

    public ObjectReadParameters withStreamStatistics(S3AInputStreamStatistics value) {
        this.streamStatistics = value;
        return this;
    }

    public ExecutorService getBoundedThreadPool() {
        return this.boundedThreadPool;
    }

    public ObjectReadParameters withBoundedThreadPool(ExecutorService value) {
        this.boundedThreadPool = value;
        return this;
    }

    public LocalDirAllocator getDirectoryAllocator() {
        return this.directoryAllocator;
    }

    public ObjectReadParameters withDirectoryAllocator(LocalDirAllocator value) {
        this.directoryAllocator = value;
        return this;
    }

    public AuditSpan getAuditSpan() {
        return this.auditSpan;
    }

    public ObjectReadParameters withAuditSpan(AuditSpan value) {
        this.auditSpan = value;
        return this;
    }

    public ObjectReadParameters validate() {
        Objects.requireNonNull(this.boundedThreadPool, "boundedThreadPool");
        Objects.requireNonNull(this.callbacks, "callbacks");
        Objects.requireNonNull(this.context, "context");
        Objects.requireNonNull(this.directoryAllocator, "directoryAllocator");
        Objects.requireNonNull(this.objectAttributes, "objectAttributes");
        Objects.requireNonNull(this.streamStatistics, "streamStatistics");
        Objects.requireNonNull(this.encryptionSecrets, "encryptionSecrets");
        Objects.requireNonNull(this.auditSpan, "auditSpan");
        return this;
    }
}

