/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.ipc;

import java.util.Objects;
import org.apache.hadoop.hbase.net.Address;
import org.apache.hadoop.hbase.security.User;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class ConnectionId {
    private static final int PRIME = 16777619;
    final User ticket;
    final String serviceName;
    final Address address;

    public ConnectionId(User ticket, String serviceName, Address address) {
        this.address = address;
        this.ticket = ticket;
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Address getAddress() {
        return this.address;
    }

    public User getTicket() {
        return this.ticket;
    }

    public String toString() {
        return this.address.toString() + "/" + this.serviceName + "/" + this.ticket;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ConnectionId)) {
            return false;
        }
        ConnectionId id = (ConnectionId)obj;
        return this.address.equals((Object)id.address) && (this.ticket != null && this.ticket.equals((Object)id.ticket) || this.ticket == id.ticket) && Objects.equals(this.serviceName, id.serviceName);
    }

    public int hashCode() {
        return ConnectionId.hashCode(this.ticket, this.serviceName, this.address);
    }

    public static int hashCode(User ticket, String serviceName, Address address) {
        return address.hashCode() + 16777619 * (16777619 * serviceName.hashCode() ^ (ticket == null ? 0 : ticket.hashCode()));
    }
}

