/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.finance.portfolio;

import java.math.BigDecimal;
import java.util.List;
import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.finance.portfolio.NormalisedPortfolio;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.matrix.BasicMatrix;
import org.ojalgo.matrix.PrimitiveMatrix;
import org.ojalgo.random.RandomUtils;
import org.ojalgo.random.process.GeometricBrownianMotion;
import org.ojalgo.type.StandardType;
import org.ojalgo.type.TypeUtils;
import org.ojalgo.type.context.NumberContext;

public abstract class FinancePortfolio
implements Comparable<FinancePortfolio> {
    protected static final BasicMatrix.Factory<PrimitiveMatrix> MATRIX_FACTORY = PrimitiveMatrix.FACTORY;

    protected FinancePortfolio() {
    }

    @Override
    public final int compareTo(FinancePortfolio reference) {
        return Double.compare(this.getSharpeRatio(), reference.getSharpeRatio());
    }

    public final GeometricBrownianMotion forecast() {
        double tmpInitialValue = PrimitiveMath.ONE;
        double tmpExpectedValue = PrimitiveMath.ONE + this.getMeanReturn();
        double tmpValueVariance = this.getReturnVariance();
        double tmpHorizon = PrimitiveMath.ONE;
        return GeometricBrownianMotion.make(tmpInitialValue, tmpExpectedValue, tmpValueVariance, tmpHorizon);
    }

    public final double getConformance(FinancePortfolio reference) {
        BasicMatrix tmpMyWeights = (BasicMatrix)MATRIX_FACTORY.columns(this.getWeights());
        BasicMatrix tmpRefWeights = (BasicMatrix)MATRIX_FACTORY.columns(reference.getWeights());
        double tmpNumerator = tmpMyWeights.dot(tmpRefWeights);
        double tmpDenom1 = PrimitiveFunction.SQRT.invoke(tmpMyWeights.dot(tmpMyWeights));
        double tmpDenom2 = PrimitiveFunction.SQRT.invoke(tmpRefWeights.dot(tmpRefWeights));
        return tmpNumerator / (tmpDenom1 * tmpDenom2);
    }

    public final double getLossProbability() {
        return this.getLossProbability(PrimitiveMath.ONE);
    }

    public final double getLossProbability(Number timePeriod) {
        GeometricBrownianMotion tmpProc = this.forecast();
        double tmpDoubleValue = timePeriod.doubleValue();
        double tmpValue = tmpProc.getValue();
        return tmpProc.getDistribution(tmpDoubleValue).getDistribution(tmpValue);
    }

    public abstract double getMeanReturn();

    public double getReturnVariance() {
        double tmpVolatility = this.getVolatility();
        return tmpVolatility * tmpVolatility;
    }

    public final double getSharpeRatio() {
        return this.getSharpeRatio(null);
    }

    public final double getSharpeRatio(Number riskFreeReturn) {
        if (riskFreeReturn != null) {
            return (this.getMeanReturn() - riskFreeReturn.doubleValue()) / this.getVolatility();
        }
        return this.getMeanReturn() / this.getVolatility();
    }

    public final double getValueAtRisk(Number confidenceLevel, Number timePeriod) {
        double aReturn = this.getMeanReturn();
        double aStdDev = this.getVolatility();
        double tmpConfidenceScale = PrimitiveMath.SQRT_TWO * RandomUtils.erfi(PrimitiveMath.ONE - PrimitiveMath.TWO * (PrimitiveMath.ONE - confidenceLevel.doubleValue()));
        double tmpTimePeriod = timePeriod.doubleValue();
        return PrimitiveFunction.MAX.invoke(PrimitiveFunction.SQRT.invoke(tmpTimePeriod) * aStdDev * tmpConfidenceScale - tmpTimePeriod * aReturn, PrimitiveMath.ZERO);
    }

    public final double getValueAtRisk95() {
        return this.getValueAtRisk(0.95, PrimitiveMath.ONE);
    }

    public double getVolatility() {
        return PrimitiveFunction.SQRT.invoke(this.getReturnVariance());
    }

    public abstract List<BigDecimal> getWeights();

    public final FinancePortfolio normalise() {
        return new NormalisedPortfolio(this, StandardType.PERCENT);
    }

    public final FinancePortfolio normalise(NumberContext weightsContext) {
        return new NormalisedPortfolio(this, weightsContext);
    }

    public String toString() {
        return TypeUtils.format("{}: Return={}, Variance={}, Volatility={}, Weights={}", this.getClass().getSimpleName(), this.getMeanReturn(), this.getReturnVariance(), this.getVolatility(), this.getWeights());
    }

    protected abstract void reset();

    public static interface Context {
        public double calculatePortfolioReturn(FinancePortfolio var1);

        public double calculatePortfolioVariance(FinancePortfolio var1);

        public BasicMatrix getAssetReturns();

        public BasicMatrix getAssetVolatilities();

        public BasicMatrix getCorrelations();

        public BasicMatrix getCovariances();

        public int size();
    }
}

