/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.api.trace;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.internal.ValidationUtil;
import io.opentelemetry.api.trace.PropagatedSpan;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.api.trace.SpanContextKey;
import io.opentelemetry.api.trace.StatusCode;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.ImplicitContextKeyed;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public interface Span
extends ImplicitContextKeyed {
    public static Span current() {
        Span span = (Span)Context.current().get(SpanContextKey.KEY);
        return span == null ? Span.getInvalid() : span;
    }

    public static Span fromContext(Context context) {
        if (context == null) {
            ValidationUtil.log("context is null");
            return Span.getInvalid();
        }
        Span span = (Span)context.get(SpanContextKey.KEY);
        return span == null ? Span.getInvalid() : span;
    }

    @Nullable
    public static Span fromContextOrNull(Context context) {
        if (context == null) {
            ValidationUtil.log("context is null");
            return null;
        }
        return (Span)context.get(SpanContextKey.KEY);
    }

    public static Span getInvalid() {
        return PropagatedSpan.INVALID;
    }

    public static Span wrap(SpanContext spanContext) {
        if (spanContext == null) {
            ValidationUtil.log("context is null");
            return Span.getInvalid();
        }
        if (!spanContext.isValid()) {
            return Span.getInvalid();
        }
        return PropagatedSpan.create(spanContext);
    }

    default public Span setAttribute(String key, String value) {
        return this.setAttribute(AttributeKey.stringKey(key), value);
    }

    default public Span setAttribute(String key, long value) {
        return this.setAttribute(AttributeKey.longKey(key), Long.valueOf(value));
    }

    default public Span setAttribute(String key, double value) {
        return this.setAttribute(AttributeKey.doubleKey(key), Double.valueOf(value));
    }

    default public Span setAttribute(String key, boolean value) {
        return this.setAttribute(AttributeKey.booleanKey(key), Boolean.valueOf(value));
    }

    public <T> Span setAttribute(AttributeKey<T> var1, T var2);

    default public Span setAttribute(AttributeKey<Long> key, int value) {
        return this.setAttribute(key, Long.valueOf(value));
    }

    default public Span setAllAttributes(Attributes attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return this;
        }
        attributes.forEach((attributeKey, value) -> this.setAttribute((AttributeKey)attributeKey, (Object)value));
        return this;
    }

    default public Span addEvent(String name) {
        return this.addEvent(name, Attributes.empty());
    }

    default public Span addEvent(String name, long timestamp, TimeUnit unit) {
        return this.addEvent(name, Attributes.empty(), timestamp, unit);
    }

    default public Span addEvent(String name, Instant timestamp) {
        if (timestamp == null) {
            return this.addEvent(name);
        }
        return this.addEvent(name, TimeUnit.SECONDS.toNanos(timestamp.getEpochSecond()) + (long)timestamp.getNano(), TimeUnit.NANOSECONDS);
    }

    public Span addEvent(String var1, Attributes var2);

    public Span addEvent(String var1, Attributes var2, long var3, TimeUnit var5);

    default public Span addEvent(String name, Attributes attributes, Instant timestamp) {
        if (timestamp == null) {
            return this.addEvent(name, attributes);
        }
        return this.addEvent(name, attributes, TimeUnit.SECONDS.toNanos(timestamp.getEpochSecond()) + (long)timestamp.getNano(), TimeUnit.NANOSECONDS);
    }

    default public Span setStatus(StatusCode statusCode) {
        return this.setStatus(statusCode, "");
    }

    public Span setStatus(StatusCode var1, String var2);

    default public Span recordException(Throwable exception) {
        return this.recordException(exception, Attributes.empty());
    }

    public Span recordException(Throwable var1, Attributes var2);

    public Span updateName(String var1);

    public void end();

    public void end(long var1, TimeUnit var3);

    default public void end(Instant timestamp) {
        if (timestamp == null) {
            this.end();
            return;
        }
        this.end(TimeUnit.SECONDS.toNanos(timestamp.getEpochSecond()) + (long)timestamp.getNano(), TimeUnit.NANOSECONDS);
    }

    public SpanContext getSpanContext();

    public boolean isRecording();

    default public Context storeInContext(Context context) {
        return context.with(SpanContextKey.KEY, (Object)this);
    }
}

