/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.buffertofile;

import com.github.davidmoten.rx.buffertofile.DataSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public final class DataSerializers {
    private DataSerializers() {
    }

    public static DataSerializer<String> string() {
        return StringHolder.INSTANCE;
    }

    public static DataSerializer<Integer> integer() {
        return IntegerHolder.INSTANCE;
    }

    public static DataSerializer<byte[]> byteArray() {
        return ByteArrayHolder.INSTANCE;
    }

    public static <T> DataSerializer<T> javaIO() {
        return JavaIOHolder.INSTANCE;
    }

    private static final class JavaIOHolder {
        static final DataSerializer<Object> INSTANCE = new DataSerializer<Object>(){

            @Override
            public void serialize(DataOutput output, Object object) throws IOException {
                ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(bytes);
                oos.writeObject(object);
                oos.close();
                byte[] array = bytes.toByteArray();
                output.writeInt(array.length);
                output.write(array);
            }

            @Override
            public Object deserialize(DataInput input) throws IOException {
                int length = input.readInt();
                byte[] array = new byte[length];
                input.readFully(array);
                ObjectInputStream ois = null;
                try {
                    ois = new ObjectInputStream(new ByteArrayInputStream(array));
                    Object object = ois.readObject();
                    return object;
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (ois != null) {
                        try {
                            ois.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }

            @Override
            public int size() {
                return 0;
            }
        };

        private JavaIOHolder() {
        }
    }

    private static final class ByteArrayHolder {
        static final DataSerializer<byte[]> INSTANCE = new DataSerializer<byte[]>(){

            @Override
            public void serialize(DataOutput output, byte[] bytes) throws IOException {
                output.writeInt(bytes.length);
                output.write(bytes);
            }

            @Override
            public byte[] deserialize(DataInput input) throws IOException {
                int length = input.readInt();
                byte[] bytes = new byte[length];
                input.readFully(bytes);
                return bytes;
            }

            @Override
            public int size() {
                return 0;
            }
        };

        private ByteArrayHolder() {
        }
    }

    private static final class IntegerHolder {
        static final DataSerializer<Integer> INSTANCE = new DataSerializer<Integer>(){

            @Override
            public void serialize(DataOutput output, Integer t) throws IOException {
                output.writeInt(t);
            }

            @Override
            public Integer deserialize(DataInput input) throws IOException {
                return input.readInt();
            }

            @Override
            public int size() {
                return 4;
            }
        };

        private IntegerHolder() {
        }
    }

    private static final class StringHolder {
        static final DataSerializer<String> INSTANCE = new DataSerializer<String>(){

            @Override
            public void serialize(DataOutput output, String t) throws IOException {
                output.writeUTF(t);
            }

            @Override
            public String deserialize(DataInput input) throws IOException {
                return input.readUTF();
            }

            @Override
            public int size() {
                return 0;
            }
        };

        private StringHolder() {
        }
    }
}

