/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.util.Shell;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessIdFileReader {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessIdFileReader.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProcessId(Path path) throws IOException {
        String processId;
        block12: {
            if (path == null) {
                throw new IOException("Trying to access process id from a null path");
            }
            LOG.debug("Accessing pid from pid file {}", (Object)path);
            processId = null;
            try (BufferedReader bufReader = null;){
                String line;
                File file = new File(path.toString());
                if (!file.exists()) break block12;
                FileInputStream fis = new FileInputStream(file);
                bufReader = new BufferedReader(new InputStreamReader((InputStream)fis, "UTF-8"));
                while ((line = bufReader.readLine()) != null) {
                    String temp = line.trim();
                    if (temp.isEmpty()) continue;
                    if (Shell.WINDOWS) {
                        try {
                            ContainerId.fromString((String)temp);
                            processId = temp;
                            break;
                        }
                        catch (Exception exception) {
                            continue;
                        }
                    }
                    try {
                        long pid = Long.parseLong(temp);
                        if (pid <= 0L) continue;
                        processId = temp;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    break;
                }
            }
        }
        LOG.debug("Got pid {} from path {}", (Object)(processId != null ? processId : "null"), (Object)path);
        return processId;
    }
}

