/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.block.procedure;

import java.util.List;
import org.eclipse.collections.api.block.procedure.Procedure;
import org.eclipse.collections.api.factory.Lists;

public final class ChainedProcedure<T>
implements Procedure<T> {
    private static final long serialVersionUID = 1L;
    private final List<Procedure<? super T>> procedures = Lists.mutable.withInitialCapacity(3);

    public static <E> ChainedProcedure<E> with(Procedure<? super E> procedure1, Procedure<? super E> procedure2) {
        ChainedProcedure<Object> chainedProcedure = new ChainedProcedure<Object>();
        chainedProcedure.addProcedure(procedure1);
        chainedProcedure.addProcedure(procedure2);
        return chainedProcedure;
    }

    public void addProcedure(Procedure<? super T> procedure) {
        this.procedures.add(procedure);
    }

    public void value(T object) {
        int size = this.procedures.size();
        for (int i = 0; i < size; ++i) {
            this.procedures.get(i).value(object);
        }
    }

    public String toString() {
        return "ChainedProcedure.with(" + this.procedures + ')';
    }
}

