/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.lib.db;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.lib.db.DBSplitter;
import org.apache.hadoop.mapreduce.lib.db.DataDrivenDBInputFormat;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class FloatSplitter
implements DBSplitter {
    private static final Log LOG = LogFactory.getLog(FloatSplitter.class);
    private static final double MIN_INCREMENT = 4.9407E-320;

    @Override
    public List<InputSplit> split(Configuration conf, ResultSet results, String colName) throws SQLException {
        int numSplits;
        LOG.warn((Object)"Generating splits for a floating-point index column. Due to the");
        LOG.warn((Object)"imprecise representation of floating-point values in Java, this");
        LOG.warn((Object)"may result in an incomplete import.");
        LOG.warn((Object)"You are strongly encouraged to choose an integral split column.");
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>();
        if (results.getString(1) == null && results.getString(2) == null) {
            splits.add(new DataDrivenDBInputFormat.DataDrivenDBInputSplit(colName + " IS NULL", colName + " IS NULL"));
            return splits;
        }
        double minVal = results.getDouble(1);
        double maxVal = results.getDouble(2);
        double splitSize = (maxVal - minVal) / (double)(numSplits = conf.getInt("mapreduce.job.maps", 1));
        if (splitSize < 4.9407E-320) {
            splitSize = 4.9407E-320;
        }
        String lowClausePrefix = colName + " >= ";
        String highClausePrefix = colName + " < ";
        double curLower = minVal;
        for (double curUpper = curLower + splitSize; curUpper < maxVal; curUpper += splitSize) {
            splits.add(new DataDrivenDBInputFormat.DataDrivenDBInputSplit(lowClausePrefix + Double.toString(curLower), highClausePrefix + Double.toString(curUpper)));
            curLower = curUpper;
        }
        if (curLower <= maxVal || splits.size() == 1) {
            splits.add(new DataDrivenDBInputFormat.DataDrivenDBInputSplit(lowClausePrefix + Double.toString(curLower), colName + " <= " + Double.toString(maxVal)));
        }
        if (results.getString(1) == null || results.getString(2) == null) {
            splits.add(new DataDrivenDBInputFormat.DataDrivenDBInputSplit(colName + " IS NULL", colName + " IS NULL"));
        }
        return splits;
    }
}

