/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.s3.signer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.aws.s3.signer.ImmutableS3SignRequest;
import org.apache.iceberg.aws.s3.signer.S3SignRequest;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.JsonUtil;

public class S3SignRequestParser {
    private static final String REGION = "region";
    private static final String METHOD = "method";
    private static final String URI = "uri";
    private static final String HEADERS = "headers";
    private static final String PROPERTIES = "properties";
    private static final String BODY = "body";

    private S3SignRequestParser() {
    }

    public static String toJson(S3SignRequest request) {
        return S3SignRequestParser.toJson(request, false);
    }

    public static String toJson(S3SignRequest request, boolean pretty) {
        return JsonUtil.generate(gen -> S3SignRequestParser.toJson(request, gen), (boolean)pretty);
    }

    public static void toJson(S3SignRequest request, JsonGenerator gen) throws IOException {
        Preconditions.checkArgument((null != request ? 1 : 0) != 0, (Object)"Invalid s3 sign request: null");
        gen.writeStartObject();
        gen.writeStringField(REGION, request.region());
        gen.writeStringField(METHOD, request.method());
        gen.writeStringField(URI, request.uri().toString());
        S3SignRequestParser.headersToJson(HEADERS, request.headers(), gen);
        if (!request.properties().isEmpty()) {
            JsonUtil.writeStringMap((String)PROPERTIES, request.properties(), (JsonGenerator)gen);
        }
        if (request.body() != null && !request.body().isEmpty()) {
            gen.writeStringField(BODY, request.body());
        }
        gen.writeEndObject();
    }

    public static S3SignRequest fromJson(String json) {
        return (S3SignRequest)JsonUtil.parse((String)json, S3SignRequestParser::fromJson);
    }

    public static S3SignRequest fromJson(JsonNode json) {
        Preconditions.checkArgument((null != json ? 1 : 0) != 0, (Object)"Cannot parse s3 sign request from null object");
        Preconditions.checkArgument((boolean)json.isObject(), (String)"Cannot parse s3 sign request from non-object: %s", (Object)json);
        String region = JsonUtil.getString((String)REGION, (JsonNode)json);
        String method = JsonUtil.getString((String)METHOD, (JsonNode)json);
        URI uri = java.net.URI.create(JsonUtil.getString((String)URI, (JsonNode)json));
        Map<String, List<String>> headers = S3SignRequestParser.headersFromJson(HEADERS, json);
        ImmutableS3SignRequest.Builder builder = ImmutableS3SignRequest.builder().region(region).method(method).uri(uri).headers(headers);
        if (json.has(PROPERTIES)) {
            builder.properties(JsonUtil.getStringMap((String)PROPERTIES, (JsonNode)json));
        }
        if (json.has(BODY)) {
            builder.body(JsonUtil.getString((String)BODY, (JsonNode)json));
        }
        return builder.build();
    }

    static void headersToJson(String property, Map<String, List<String>> headers, JsonGenerator gen) throws IOException {
        gen.writeObjectFieldStart(property);
        for (Map.Entry<String, List<String>> entry : headers.entrySet()) {
            gen.writeFieldName(entry.getKey());
            gen.writeStartArray();
            for (String val : entry.getValue()) {
                gen.writeString(val);
            }
            gen.writeEndArray();
        }
        gen.writeEndObject();
    }

    static Map<String, List<String>> headersFromJson(String property, JsonNode json) {
        HashMap headers = Maps.newHashMap();
        JsonNode headersNode = JsonUtil.get((String)property, (JsonNode)json);
        headersNode.fields().forEachRemaining(entry -> {
            String key = (String)entry.getKey();
            List<String> values = Arrays.asList(JsonUtil.getStringArray((JsonNode)((JsonNode)entry.getValue())));
            headers.put(key, values);
        });
        return headers;
    }
}

