/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.cli;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.geode.annotations.Experimental;
import org.apache.geode.cache.Cache;
import org.apache.geode.cache.execute.Execution;
import org.apache.geode.cache.execute.Function;
import org.apache.geode.cache.execute.FunctionService;
import org.apache.geode.cache.execute.ResultCollector;
import org.apache.geode.distributed.ConfigurationPersistenceService;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.InternalLocator;
import org.apache.geode.internal.cache.InternalCache;
import org.apache.geode.internal.serialization.KnownVersion;
import org.apache.geode.management.ManagementService;
import org.apache.geode.management.api.ClusterManagementService;
import org.apache.geode.management.internal.cli.shell.Gfsh;
import org.apache.geode.management.internal.exceptions.EntityNotFoundException;
import org.apache.geode.management.internal.functions.CliFunctionResult;
import org.apache.geode.management.internal.i18n.CliStrings;
import org.apache.geode.management.internal.util.ManagementUtils;
import org.apache.geode.security.ResourcePermission;
import org.apache.shiro.subject.Subject;
import org.springframework.shell.core.CommandMarker;

@Experimental
public abstract class GfshCommand
implements CommandMarker {
    public static final String EXPERIMENTAL = "(Experimental) ";
    private InternalCache cache;

    public boolean isOnlineCommandAvailable() {
        Gfsh gfsh = Gfsh.getCurrentInstance();
        if (gfsh == null) {
            return true;
        }
        return gfsh.isConnectedAndReady();
    }

    public boolean affectsClusterConfiguration() {
        return false;
    }

    public void authorize(ResourcePermission.Resource resource, ResourcePermission.Operation operation, ResourcePermission.Target target) {
        this.cache.getSecurityService().authorize(resource, operation, target);
    }

    public void authorize(ResourcePermission.Resource resource, ResourcePermission.Operation operation, String target) {
        this.cache.getSecurityService().authorize(resource, operation, target);
    }

    public void authorize(ResourcePermission.Resource resource, ResourcePermission.Operation operation, String target, String key) {
        this.cache.getSecurityService().authorize(resource, operation, target, (Object)key);
    }

    public Cache getCache() {
        if (this.cache == null) {
            return null;
        }
        return this.cache.getCacheForProcessingClientRequests();
    }

    public <T extends ManagementService> T getManagementService() {
        return (T)ManagementService.getExistingManagementService((Cache)this.cache);
    }

    public <T extends ConfigurationPersistenceService> T getConfigurationPersistenceService() {
        InternalLocator locator = InternalLocator.getLocator();
        return (T)(locator == null ? null : locator.getConfigurationPersistenceService());
    }

    public ClusterManagementService getClusterManagementService() {
        InternalLocator locator = InternalLocator.getLocator();
        return locator == null ? null : locator.getClusterManagementService();
    }

    public void setCache(Cache cache) {
        this.cache = (InternalCache)cache;
    }

    public boolean isSharedConfigurationRunning() {
        InternalLocator locator = InternalLocator.getLocator();
        return locator != null && locator.isSharedConfigurationRunning();
    }

    public Subject getSubject() {
        return this.cache.getSecurityService().getSubject();
    }

    public DistributedMember getMember(String memberName) {
        DistributedMember member = this.findMember(memberName);
        if (member == null) {
            throw new EntityNotFoundException(CliStrings.format((String)"Member {0} could not be found.  Please verify the member name or ID and try again.", (Object)memberName));
        }
        return member;
    }

    public DistributedMember findMember(String memberName) {
        return ManagementUtils.getDistributedMemberByNameOrId((String)memberName, (InternalCache)((InternalCache)this.getCache()));
    }

    public Set<DistributedMember> getAllMembers() {
        return ManagementUtils.getAllMembers((InternalCache)this.cache);
    }

    public Set<DistributedMember> getAllNormalMembers() {
        return ManagementUtils.getAllNormalMembers((InternalCache)this.cache);
    }

    public Set<DistributedMember> getNormalMembersWithSameOrNewerVersion(KnownVersion version) {
        return ManagementUtils.getNormalMembersWithSameOrNewerVersion((InternalCache)this.cache, (KnownVersion)version);
    }

    public Execution getMembersFunctionExecutor(Set<DistributedMember> members) {
        return FunctionService.onMembers(members);
    }

    public Set<DistributedMember> findMembers(String[] groups, String[] members) {
        return ManagementUtils.findMembers((String[])groups, (String[])members, (InternalCache)this.cache);
    }

    public Set<DistributedMember> findAllOtherLocators() {
        Set<DistributedMember> allLocators = this.findAllLocators();
        String thisId = this.getCache().getDistributedSystem().getDistributedMember().getId();
        return allLocators.stream().filter(m -> !m.getId().equals(thisId)).collect(Collectors.toSet());
    }

    public Set<DistributedMember> findAllLocators() {
        return ManagementUtils.getAllLocators((InternalCache)this.cache);
    }

    public Set<DistributedMember> getMembers(String[] groups, String[] members) {
        Set<DistributedMember> matchingMembers = this.findMembers(groups, members);
        if (matchingMembers.size() == 0) {
            throw new EntityNotFoundException("No Members Found");
        }
        return matchingMembers;
    }

    public Set<DistributedMember> findMembersIncludingLocators(String[] groups, String[] members) {
        return ManagementUtils.findMembersIncludingLocators((String[])groups, (String[])members, (InternalCache)((InternalCache)this.getCache()));
    }

    public Set<DistributedMember> getMembersIncludingLocators(String[] groups, String[] members) {
        Set<DistributedMember> matchingMembers = this.findMembersIncludingLocators(groups, members);
        if (matchingMembers.size() == 0) {
            throw new EntityNotFoundException("No Members Found");
        }
        return matchingMembers;
    }

    public Set<DistributedMember> findMembersForRegion(String regionPath) {
        return ManagementUtils.getRegionAssociatedMembers((String)regionPath, (InternalCache)this.cache, (boolean)true);
    }

    public Set<DistributedMember> findAnyMembersForRegion(String regionPath) {
        return ManagementUtils.getRegionAssociatedMembers((String)regionPath, (InternalCache)this.cache, (boolean)false);
    }

    public ResultCollector<?, ?> executeFunction(Function<?> function, Object args, Set<DistributedMember> targetMembers) {
        return ManagementUtils.executeFunction(function, (Object)args, targetMembers);
    }

    public ResultCollector<?, ?> executeFunction(Function<?> function, Object args, DistributedMember targetMember) {
        return this.executeFunction(function, args, Collections.singleton(targetMember));
    }

    public CliFunctionResult executeFunctionAndGetFunctionResult(Function<?> function, Object args, DistributedMember targetMember) {
        ResultCollector<?, ?> rc = this.executeFunction(function, args, Collections.singleton(targetMember));
        List results = CliFunctionResult.cleanResults((List)((List)rc.getResult()));
        return results.size() > 0 ? (CliFunctionResult)results.get(0) : null;
    }

    public List<CliFunctionResult> executeAndGetFunctionResult(Function<?> function, Object args, Set<DistributedMember> targetMembers) {
        ResultCollector<?, ?> rc = this.executeFunction(function, args, targetMembers);
        return CliFunctionResult.cleanResults((List)((List)rc.getResult()));
    }

    public boolean poll(long timeout, TimeUnit unit, Supplier<Boolean> function) {
        long startWaitTime = System.currentTimeMillis();
        long waitTime = unit.toMillis(timeout);
        do {
            try {
                if (function.get().booleanValue()) {
                    return true;
                }
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return false;
            }
        } while (System.currentTimeMillis() - startWaitTime < waitTime);
        return false;
    }
}

