/*
 * Decompiled with CFR 0.152.
 */
package mx4j.monitor;

import java.math.BigDecimal;
import java.math.BigInteger;
import javax.management.MBeanNotificationInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import mx4j.log.Logger;
import mx4j.monitor.MX4JGaugeMonitorMBean;
import mx4j.monitor.MX4JMonitor;

public class MX4JGaugeMonitor
extends MX4JMonitor
implements MX4JGaugeMonitorMBean {
    private static Integer ZERO = new Integer(0);
    private Number highThreshold = ZERO;
    private Number lowThreshold = ZERO;
    private boolean notifyHigh;
    private boolean notifyLow;
    private boolean differenceMode;
    static /* synthetic */ Class class$mx4j$monitor$MX4JGaugeMonitorMBean;

    public MX4JGaugeMonitor() throws NotCompliantMBeanException {
        super(class$mx4j$monitor$MX4JGaugeMonitorMBean == null ? (class$mx4j$monitor$MX4JGaugeMonitorMBean = MX4JGaugeMonitor.class$("mx4j.monitor.MX4JGaugeMonitorMBean")) : class$mx4j$monitor$MX4JGaugeMonitorMBean);
    }

    protected MX4JGaugeMonitor(Class management) throws NotCompliantMBeanException {
        super(management);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return new MBeanNotificationInfo[0];
    }

    public synchronized Number getHighThreshold() {
        return this.highThreshold;
    }

    public synchronized Number getLowThreshold() {
        return this.lowThreshold;
    }

    public void setThresholds(Number highValue, Number lowValue) throws IllegalArgumentException {
        if (highValue == null) {
            throw new IllegalArgumentException("High Threshold cannot be null");
        }
        if (lowValue == null) {
            throw new IllegalArgumentException("Low Threshold cannot be null");
        }
        if (highValue.getClass() != lowValue.getClass()) {
            throw new IllegalArgumentException("Thresholds must be of the same type");
        }
        if (this.compare(highValue, lowValue) < 0) {
            throw new IllegalArgumentException("High threshold cannot be lower than low threshold");
        }
        this.highThreshold = highValue;
        this.lowThreshold = lowValue;
    }

    public synchronized boolean getNotifyHigh() {
        return this.notifyHigh;
    }

    public synchronized boolean getNotifyLow() {
        return this.notifyLow;
    }

    public synchronized void setNotifyHigh(boolean notifyHigh) {
        this.notifyHigh = notifyHigh;
    }

    public synchronized void setNotifyLow(boolean notifyLow) {
        this.notifyLow = notifyLow;
    }

    public synchronized boolean getDifferenceMode() {
        return this.differenceMode;
    }

    public synchronized void setDifferenceMode(boolean differenceMode) {
        this.differenceMode = differenceMode;
    }

    public Number getDerivedGauge(ObjectName objectName) {
        GaugeMonitorInfo info = (GaugeMonitorInfo)this.getMonitorInfo(objectName);
        return info.getGauge();
    }

    public long getDerivedGaugeTimeStamp(ObjectName objectName) {
        GaugeMonitorInfo info = (GaugeMonitorInfo)this.getMonitorInfo(objectName);
        return info.getTimestamp();
    }

    protected MX4JMonitor.MonitorInfo createMonitorInfo() {
        return new GaugeMonitorInfo();
    }

    protected int compare(Number left, Number right) {
        if (left instanceof BigDecimal && right instanceof BigDecimal) {
            return ((BigDecimal)left).compareTo((BigDecimal)right);
        }
        if (left instanceof BigInteger && right instanceof BigInteger) {
            return ((BigInteger)left).compareTo((BigInteger)right);
        }
        return new Double(left.doubleValue()).compareTo(new Double(right.doubleValue()));
    }

    protected Number sub(Number left, Number right) {
        if (left instanceof BigDecimal && right instanceof BigDecimal) {
            return ((BigDecimal)left).subtract((BigDecimal)right);
        }
        if (left instanceof BigDecimal) {
            return ((BigDecimal)left).subtract(new BigDecimal(right.doubleValue()));
        }
        if (left instanceof BigInteger && right instanceof BigInteger) {
            return ((BigInteger)left).subtract((BigInteger)right);
        }
        if (left instanceof BigInteger) {
            return ((BigInteger)left).subtract(BigInteger.valueOf(right.longValue()));
        }
        if (left instanceof Double || right instanceof Double) {
            return new Double(left.doubleValue() - right.doubleValue());
        }
        if (left instanceof Float || right instanceof Float) {
            return new Float(left.floatValue() - right.floatValue());
        }
        if (left instanceof Long || right instanceof Long) {
            return new Long(left.longValue() - right.longValue());
        }
        if (left instanceof Integer || right instanceof Integer) {
            return new Integer(left.intValue() - right.intValue());
        }
        if (left instanceof Short || right instanceof Short) {
            return new Short((short)(left.shortValue() - right.shortValue()));
        }
        if (left instanceof Byte || right instanceof Byte) {
            return new Byte((byte)(left.byteValue() - right.byteValue()));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void monitor(ObjectName name, String attribute, Object value, MX4JMonitor.MonitorInfo monitorInfo) {
        if (!(value instanceof Number)) {
            this.sendErrorNotification(monitorInfo, "jmx.monitor.error.type", "Attribute type must be a Number, not " + value.getClass(), name, attribute);
            return;
        }
        Number gauge = (Number)value;
        Number high = null;
        Number low = null;
        MX4JGaugeMonitor mX4JGaugeMonitor = this;
        synchronized (mX4JGaugeMonitor) {
            high = this.getHighThreshold();
            low = this.getLowThreshold();
        }
        Class<?> gaugeClass = gauge.getClass();
        if (high != ZERO && high.getClass() != gaugeClass) {
            this.sendErrorNotification(monitorInfo, "jmx.monitor.error.threshold", "Threshold type " + high.getClass() + " must be of same type of the attribute " + gaugeClass, name, attribute);
            return;
        }
        if (low != ZERO && low.getClass() != gaugeClass) {
            this.sendErrorNotification(monitorInfo, "jmx.monitor.error.threshold", "Offset type " + low.getClass() + " must be of same type of the attribute " + gaugeClass, name, attribute);
            return;
        }
        Logger logger = this.getLogger();
        GaugeMonitorInfo info = (GaugeMonitorInfo)monitorInfo;
        if (logger.isEnabledFor(10)) {
            logger.debug("Computing gauge, previous values are: " + info);
            logger.debug("Current values are: gauge=" + gauge + ", highThreshold=" + high + ", lowThreshold=" + low);
        }
        if (this.getDifferenceMode()) {
            Number diffGauge = this.sub(gauge, info.getGauge());
            if (logger.isEnabledFor(10)) {
                logger.debug("CounterMonitor in difference mode, difference gauge=" + diffGauge);
            }
            this.compareAndSendNotification(diffGauge, low, high, info, name, attribute);
        } else {
            if (logger.isEnabledFor(10)) {
                logger.debug("CounterMonitor in absolute mode, gauge=" + gauge);
            }
            this.compareAndSendNotification(gauge, low, high, info, name, attribute);
        }
        info.setGauge(gauge);
        info.setTimestamp(System.currentTimeMillis());
    }

    private void compareAndSendNotification(Number gauge, Number low, Number high, GaugeMonitorInfo info, ObjectName name, String attribute) {
        Logger logger = this.getLogger();
        if (info.isHighNotified() && this.compare(gauge, low) > 0) {
            if (logger.isEnabledFor(10)) {
                logger.debug("High threshold " + high + " already notified, gauge " + gauge + " not below low threshold " + low);
            }
            return;
        }
        if (info.isLowNotified() && this.compare(gauge, high) < 0) {
            if (logger.isEnabledFor(10)) {
                logger.debug("Low threshold " + low + " already notified, gauge " + gauge + " not above high threshold " + high);
            }
            return;
        }
        if (this.compare(gauge, high) >= 0) {
            if (logger.isEnabledFor(10)) {
                logger.debug("Gauge above high threshold: gauge=" + gauge + ", high threshold=" + high + ", low threshold=" + low);
            }
            info.setLowNotified(false);
            if (this.getNotifyHigh()) {
                if (logger.isEnabledFor(10)) {
                    logger.debug("Sending high threshold exceeded notification");
                }
                info.setHighNotified(true);
                this.sendNotification("jmx.monitor.gauge.high", "High threshold " + high + " exceeded: " + gauge, name, attribute, gauge, high);
            } else {
                info.setHighNotified(false);
                if (logger.isEnabledFor(10)) {
                    logger.debug("GaugeMonitor is configured in non-high-notification mode");
                }
            }
        } else if (this.compare(gauge, low) <= 0) {
            if (logger.isEnabledFor(10)) {
                logger.debug("Gauge below low threshold: gauge=" + gauge + ", low threshold=" + low + ", high threshold=" + high);
            }
            info.setHighNotified(false);
            if (this.getNotifyLow()) {
                if (logger.isEnabledFor(10)) {
                    logger.debug("Sending low threshold exceeded notification");
                }
                info.setLowNotified(true);
                this.sendNotification("jmx.monitor.gauge.low", "Low threshold " + low + " exceeded: " + gauge, name, attribute, gauge, low);
            } else {
                info.setLowNotified(false);
                if (logger.isEnabledFor(10)) {
                    logger.debug("GaugeMonitor is configured in non-low-notification mode");
                }
            }
        } else {
            info.setHighNotified(false);
            info.setLowNotified(false);
            if (logger.isEnabledFor(10)) {
                logger.debug("Gauge between thresholds: gauge=" + gauge + ", low threshold=" + low + ", high threshold=" + high);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static /* synthetic */ Integer access$000() {
        return ZERO;
    }

    protected class GaugeMonitorInfo
    extends MX4JMonitor.MonitorInfo {
        private Number gauge = MX4JGaugeMonitor.access$000();
        private long timestamp;
        private boolean highNotified;
        private boolean lowNotified;

        protected GaugeMonitorInfo() {
            super(MX4JGaugeMonitor.this);
        }

        public Number getGauge() {
            return this.gauge;
        }

        public void setGauge(Number gauge) {
            this.gauge = gauge;
        }

        public long getTimestamp() {
            return this.timestamp;
        }

        public void setTimestamp(long timestamp) {
            this.timestamp = timestamp;
        }

        public boolean isHighNotified() {
            return this.highNotified;
        }

        public void setHighNotified(boolean highNotified) {
            this.highNotified = highNotified;
        }

        public boolean isLowNotified() {
            return this.lowNotified;
        }

        public void setLowNotified(boolean lowNotified) {
            this.lowNotified = lowNotified;
        }

        public void clearNotificationStatus() {
            super.clearNotificationStatus();
            this.highNotified = false;
            this.lowNotified = false;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer(super.toString());
            buffer.append(", gauge=").append(this.getGauge());
            buffer.append(", lowNotified=").append(this.isLowNotified());
            buffer.append(", highNotified=").append(this.isHighNotified());
            return buffer.toString();
        }
    }
}

