/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.management.internal.configuration.mutators;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.geode.cache.configuration.CacheConfig;
import org.apache.geode.cache.configuration.DiskStoreType;
import org.apache.geode.distributed.ConfigurationPersistenceService;
import org.apache.geode.management.configuration.DiskStore;
import org.apache.geode.management.internal.configuration.converters.DiskStoreConverter;
import org.apache.geode.management.internal.configuration.mutators.CacheConfigurationManager;

public class DiskStoreManager
extends CacheConfigurationManager<DiskStore> {
    private final DiskStoreConverter diskStoreConverter = new DiskStoreConverter();

    public DiskStoreManager(ConfigurationPersistenceService service) {
        super(service);
    }

    @Override
    public void add(DiskStore config, CacheConfig existing) {
        List<DiskStoreType> diskStoreTypes = existing.getDiskStores();
        if (diskStoreTypes.stream().noneMatch(diskStoreType -> diskStoreType.getName().equals(config.getName()))) {
            diskStoreTypes.add((DiskStoreType)this.diskStoreConverter.fromConfigObject(config));
        }
    }

    @Override
    public void update(DiskStore config, CacheConfig existing) {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    public void delete(DiskStore config, CacheConfig existing) {
        existing.getDiskStores().stream().filter(diskStoreType -> config.getName().equals(diskStoreType.getName())).findFirst().ifPresent(diskStore -> existing.getDiskStores().remove(diskStore));
    }

    @Override
    public List<DiskStore> list(DiskStore filterConfig, CacheConfig existing) {
        return existing.getDiskStores().stream().filter(diskStoreType -> StringUtils.isEmpty((CharSequence)filterConfig.getName()) || filterConfig.getName().equals(diskStoreType.getName())).map(this.diskStoreConverter::fromXmlObject).collect(Collectors.toList());
    }

    @Override
    public DiskStore get(DiskStore config, CacheConfig existing) {
        return existing.getDiskStores().stream().filter(diskStoreType -> diskStoreType.getName().equals(config.getName())).map(this.diskStoreConverter::fromXmlObject).findFirst().orElse(null);
    }
}

