/*
 * Decompiled with CFR 0.152.
 */
package org.apache.geode.internal.cache.partitioned.rebalance;

import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.TreeSet;
import org.apache.geode.distributed.DistributedMember;
import org.apache.geode.distributed.internal.membership.InternalDistributedMember;
import org.apache.geode.internal.cache.partitioned.rebalance.RebalanceDirectorAdapter;
import org.apache.geode.internal.cache.partitioned.rebalance.model.Bucket;
import org.apache.geode.internal.cache.partitioned.rebalance.model.Member;
import org.apache.geode.internal.cache.partitioned.rebalance.model.MemberRollup;
import org.apache.geode.internal.cache.partitioned.rebalance.model.Move;
import org.apache.geode.internal.cache.partitioned.rebalance.model.PartitionedRegionLoadModel;

public class PercentageMoveDirector
extends RebalanceDirectorAdapter {
    private PartitionedRegionLoadModel model;
    private final InternalDistributedMember source;
    private final InternalDistributedMember target;
    private final float percentage;
    private float loadToMove;
    private NavigableSet<Bucket> orderedBuckets;

    public PercentageMoveDirector(DistributedMember source, DistributedMember target, float percentage) {
        this.source = (InternalDistributedMember)source;
        this.target = (InternalDistributedMember)target;
        this.percentage = percentage;
    }

    @Override
    public void initialize(PartitionedRegionLoadModel model) {
        MemberRollup sourceMember = model.getMember(this.source);
        if (sourceMember == null) {
            throw new IllegalStateException(String.format("Source member does not exist or is not a data store for the partitioned region %s: %s", model.getName(), this.source));
        }
        float sourceLoad = sourceMember.getTotalLoad();
        this.loadToMove = sourceLoad * this.percentage / 100.0f;
        this.membershipChanged(model);
    }

    @Override
    public void membershipChanged(PartitionedRegionLoadModel model) {
        this.model = model;
        MemberRollup sourceMember = model.getMember(this.source);
        if (sourceMember == null) {
            throw new IllegalStateException(String.format("Source member does not exist or is not a data store for the partitioned region %s: %s", model.getName(), this.source));
        }
        this.orderedBuckets = new TreeSet<Bucket>(new LoadComparator());
        for (Bucket bucket : sourceMember.getBuckets()) {
            float bucketLoad = bucket.getLoad();
            if (!(bucketLoad <= this.loadToMove)) continue;
            this.orderedBuckets.add(bucket);
        }
    }

    @Override
    public boolean nextStep() {
        MemberRollup targetMember = this.model.getMember(this.target);
        MemberRollup sourceMember = this.model.getMember(this.source);
        if (targetMember == null) {
            throw new IllegalStateException(String.format("Target member does not exist or is not a data store for the partitioned region %s: %s", this.model.getName(), this.target));
        }
        if (targetMember.equals(sourceMember)) {
            throw new IllegalStateException(String.format("Target member is the same as source member for the partitioned region %s: %s", this.model.getName(), this.target));
        }
        if (this.orderedBuckets.isEmpty()) {
            return false;
        }
        Bucket bucket = (Bucket)this.orderedBuckets.last();
        float load = bucket.getLoad();
        if (((Member)targetMember).willAcceptBucket(bucket, sourceMember, this.model.enforceUniqueZones()).willAccept() && this.model.moveBucket(new Move(sourceMember, targetMember, bucket))) {
            Bucket next;
            this.loadToMove -= load;
            Iterator<Bucket> itr = this.orderedBuckets.descendingIterator();
            while (itr.hasNext() && (next = itr.next()).getLoad() > this.loadToMove) {
                itr.remove();
            }
        }
        this.orderedBuckets.remove(bucket);
        return true;
    }

    private static class LoadComparator
    implements Comparator<Bucket> {
        private LoadComparator() {
        }

        @Override
        public int compare(Bucket o1, Bucket o2) {
            int result = Float.compare(o1.getLoad(), o2.getLoad());
            if (result == 0) {
                result = o2.getId() - o1.getId();
            }
            return result;
        }
    }
}

