/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import 'package:fory/src/const/types.dart';
import 'package:fory/src/meta/meta_string_byte.dart';
import 'package:fory/src/serializer/serializer.dart';

class TypeInfo {
  final Type dartType;
  final ObjType objType;
  final String? tag;
  final MetaStringBytes? typeNameBytes;
  final MetaStringBytes? nsBytes;
  // Stored as unsigned 32-bit; -1 (0xffffffff) means "unset".
  final int userTypeId;
  late Serializer ser;

  TypeInfo(
    this.dartType,
    this.objType,
    this.tag,
    this.typeNameBytes,
    this.nsBytes,
    {this.userTypeId = kInvalidUserTypeId}
  );

  TypeInfo.fromInnerType(
    this.dartType,
    this.objType,
    this.ser,
  ) : tag = null,
      typeNameBytes = null,
      nsBytes = null,
      userTypeId = kInvalidUserTypeId;
}
