/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.compress;

import com.github.luben.zstd.BufferPool;
import com.github.luben.zstd.RecyclingBufferPool;
import com.github.luben.zstd.ZstdInputStreamNoFinalizer;
import com.github.luben.zstd.ZstdOutputStreamNoFinalizer;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.compress.Compression;
import org.apache.kafka.common.record.CompressionType;
import org.apache.kafka.common.utils.BufferSupplier;
import org.apache.kafka.common.utils.ByteBufferInputStream;
import org.apache.kafka.common.utils.ByteBufferOutputStream;
import org.apache.kafka.common.utils.ChunkedBytesStream;

public class ZstdCompression
implements Compression {
    private final int level;

    private ZstdCompression(int level) {
        this.level = level;
    }

    @Override
    public CompressionType type() {
        return CompressionType.ZSTD;
    }

    @Override
    public OutputStream wrapForOutput(ByteBufferOutputStream bufferStream, byte messageVersion) {
        try {
            return new BufferedOutputStream(new ZstdOutputStreamNoFinalizer(bufferStream, RecyclingBufferPool.INSTANCE, this.level), 16384);
        }
        catch (Throwable e) {
            throw new KafkaException(e);
        }
    }

    @Override
    public InputStream wrapForInput(ByteBuffer buffer, byte messageVersion, BufferSupplier decompressionBufferSupplier) {
        try {
            return new ChunkedBytesStream(ZstdCompression.wrapForZstdInput(buffer, decompressionBufferSupplier), decompressionBufferSupplier, this.decompressionOutputSize(), false);
        }
        catch (Throwable e) {
            throw new KafkaException(e);
        }
    }

    public static ZstdInputStreamNoFinalizer wrapForZstdInput(ByteBuffer buffer, final BufferSupplier decompressionBufferSupplier) throws IOException {
        BufferPool bufferPool = new BufferPool(){

            @Override
            public ByteBuffer get(int capacity) {
                return decompressionBufferSupplier.get(capacity);
            }

            @Override
            public void release(ByteBuffer buffer) {
                decompressionBufferSupplier.release(buffer);
            }
        };
        return new ZstdInputStreamNoFinalizer(new ByteBufferInputStream(buffer), bufferPool);
    }

    @Override
    public int decompressionOutputSize() {
        return 16384;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZstdCompression that = (ZstdCompression)o;
        return this.level == that.level;
    }

    public int hashCode() {
        return Objects.hash(this.level);
    }

    public static class Builder
    implements Compression.Builder<ZstdCompression> {
        private int level = CompressionType.ZSTD.defaultLevel();

        public Builder level(int level) {
            if (level < CompressionType.ZSTD.minLevel() || CompressionType.ZSTD.maxLevel() < level) {
                throw new IllegalArgumentException("zstd doesn't support given compression level: " + level);
            }
            this.level = level;
            return this;
        }

        @Override
        public ZstdCompression build() {
            return new ZstdCompression(this.level);
        }
    }
}

