/*
 * Decompiled with CFR 0.152.
 */
package io.github.ollama4j.models.request;

import com.fasterxml.jackson.core.JsonProcessingException;
import io.github.ollama4j.exceptions.OllamaBaseException;
import io.github.ollama4j.models.chat.OllamaChatMessage;
import io.github.ollama4j.models.chat.OllamaChatRequest;
import io.github.ollama4j.models.chat.OllamaChatResponseModel;
import io.github.ollama4j.models.chat.OllamaChatResult;
import io.github.ollama4j.models.chat.OllamaChatToolCalls;
import io.github.ollama4j.models.generate.OllamaTokenHandler;
import io.github.ollama4j.models.request.Auth;
import io.github.ollama4j.models.request.OllamaEndpointCaller;
import io.github.ollama4j.models.response.OllamaErrorResponse;
import io.github.ollama4j.utils.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OllamaChatEndpointCaller
extends OllamaEndpointCaller {
    private static final Logger LOG = LoggerFactory.getLogger(OllamaChatEndpointCaller.class);
    private OllamaTokenHandler tokenHandler;

    public OllamaChatEndpointCaller(String host, Auth auth, long requestTimeoutSeconds, boolean verbose) {
        super(host, auth, requestTimeoutSeconds, verbose);
    }

    @Override
    protected String getEndpointSuffix() {
        return "/api/chat";
    }

    @Override
    protected boolean parseResponseAndAddToBuffer(String line, StringBuilder responseBuffer, StringBuilder thinkingBuffer) {
        try {
            OllamaChatResponseModel ollamaResponseModel = Utils.getObjectMapper().readValue(line, OllamaChatResponseModel.class);
            OllamaChatMessage message = ollamaResponseModel.getMessage();
            if (message != null) {
                if (message.getThinking() != null) {
                    thinkingBuffer.append(message.getThinking());
                } else {
                    responseBuffer.append(message.getContent());
                }
                if (this.tokenHandler != null) {
                    this.tokenHandler.accept(ollamaResponseModel);
                }
            }
            return ollamaResponseModel.isDone();
        }
        catch (JsonProcessingException e) {
            LOG.error("Error parsing the Ollama chat response!", e);
            return true;
        }
    }

    public OllamaChatResult call(OllamaChatRequest body, OllamaTokenHandler tokenHandler) throws OllamaBaseException, IOException, InterruptedException {
        this.tokenHandler = tokenHandler;
        return this.callSync(body);
    }

    public OllamaChatResult callSync(OllamaChatRequest body) throws OllamaBaseException, IOException, InterruptedException {
        HttpClient httpClient = HttpClient.newHttpClient();
        URI uri = URI.create(this.getHost() + this.getEndpointSuffix());
        HttpRequest.Builder requestBuilder = this.getRequestBuilderDefault(uri).POST(body.getBodyPublisher());
        HttpRequest request = requestBuilder.build();
        if (this.isVerbose()) {
            LOG.info("Asking model: {}", (Object)body);
        }
        HttpResponse<InputStream> response = httpClient.send(request, HttpResponse.BodyHandlers.ofInputStream());
        int statusCode = response.statusCode();
        InputStream responseBodyStream = response.body();
        StringBuilder responseBuffer = new StringBuilder();
        StringBuilder thinkingBuffer = new StringBuilder();
        OllamaChatResponseModel ollamaChatResponseModel = null;
        List<OllamaChatToolCalls> wantedToolsForStream = null;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(responseBodyStream, StandardCharsets.UTF_8));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (statusCode == 404) {
                    LOG.warn("Status code: 404 (Not Found)");
                    OllamaErrorResponse ollamaResponseModel = Utils.getObjectMapper().readValue(line, OllamaErrorResponse.class);
                    responseBuffer.append(ollamaResponseModel.getError());
                    continue;
                }
                if (statusCode == 401) {
                    LOG.warn("Status code: 401 (Unauthorized)");
                    OllamaErrorResponse ollamaResponseModel = Utils.getObjectMapper().readValue("{\"error\":\"Unauthorized\"}", OllamaErrorResponse.class);
                    responseBuffer.append(ollamaResponseModel.getError());
                    continue;
                }
                if (statusCode == 400) {
                    LOG.warn("Status code: 400 (Bad Request)");
                    OllamaErrorResponse ollamaResponseModel = Utils.getObjectMapper().readValue(line, OllamaErrorResponse.class);
                    responseBuffer.append(ollamaResponseModel.getError());
                    continue;
                }
                if (statusCode == 500) {
                    LOG.warn("Status code: 500 (Internal Server Error)");
                    OllamaErrorResponse ollamaResponseModel = Utils.getObjectMapper().readValue(line, OllamaErrorResponse.class);
                    responseBuffer.append(ollamaResponseModel.getError());
                    continue;
                }
                boolean finished = this.parseResponseAndAddToBuffer(line, responseBuffer, thinkingBuffer);
                ollamaChatResponseModel = Utils.getObjectMapper().readValue(line, OllamaChatResponseModel.class);
                if (body.stream && ollamaChatResponseModel.getMessage().getToolCalls() != null) {
                    wantedToolsForStream = ollamaChatResponseModel.getMessage().getToolCalls();
                }
                if (!finished || !body.stream) continue;
                ollamaChatResponseModel.getMessage().setContent(responseBuffer.toString());
                ollamaChatResponseModel.getMessage().setThinking(thinkingBuffer.toString());
                break;
            }
        }
        if (statusCode != 200) {
            LOG.error("Status code " + statusCode);
            throw new OllamaBaseException(responseBuffer.toString());
        }
        if (wantedToolsForStream != null) {
            ollamaChatResponseModel.getMessage().setToolCalls(wantedToolsForStream);
        }
        OllamaChatResult ollamaResult = new OllamaChatResult(ollamaChatResponseModel, body.getMessages());
        if (this.isVerbose()) {
            LOG.info("Model response: " + String.valueOf(ollamaResult));
        }
        return ollamaResult;
    }
}

