/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.functions.table;

import org.apache.flink.annotation.Internal;
import org.apache.flink.table.data.ArrayData;
import org.apache.flink.table.data.GenericRowData;
import org.apache.flink.table.data.MapData;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.data.utils.JoinedRowData;
import org.apache.flink.table.functions.SpecializedFunction;
import org.apache.flink.table.functions.UserDefinedFunction;
import org.apache.flink.table.runtime.functions.table.UnnestRowsFunctionBase;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;

@Internal
public class UnnestRowsWithOrdinalityFunction
extends UnnestRowsFunctionBase {
    public UnnestRowsWithOrdinalityFunction() {
        super(true);
    }

    @Override
    protected UserDefinedFunction createCollectionUnnestFunction(SpecializedFunction.SpecializedContext context, LogicalType elementType, ArrayData.ElementGetter elementGetter) {
        return new CollectionUnnestWithOrdinalityFunction(context, UnnestRowsWithOrdinalityFunction.wrapWithOrdinality(elementType), elementGetter);
    }

    @Override
    protected UserDefinedFunction createMapUnnestFunction(SpecializedFunction.SpecializedContext context, RowType keyValTypes, ArrayData.ElementGetter keyGetter, ArrayData.ElementGetter valueGetter) {
        return new MapUnnestWithOrdinalityFunction(context, UnnestRowsWithOrdinalityFunction.wrapWithOrdinality((LogicalType)keyValTypes), keyGetter, valueGetter);
    }

    public static final class MapUnnestWithOrdinalityFunction
    extends UnnestRowsFunctionBase.UnnestTableFunctionBase {
        private static final long serialVersionUID = 1L;
        private final ArrayData.ElementGetter keyGetter;
        private final ArrayData.ElementGetter valueGetter;

        public MapUnnestWithOrdinalityFunction(SpecializedFunction.SpecializedContext context, LogicalType keyValTypes, ArrayData.ElementGetter keyGetter, ArrayData.ElementGetter valueGetter) {
            super(context, keyValTypes, true);
            this.keyGetter = keyGetter;
            this.valueGetter = valueGetter;
        }

        public void eval(MapData mapData) {
            this.evalMapData(mapData, this.keyGetter, this.valueGetter, (key, value, position) -> this.collect(GenericRowData.of((Object[])new Object[]{key, value, position})));
        }
    }

    public static final class CollectionUnnestWithOrdinalityFunction
    extends UnnestRowsFunctionBase.UnnestTableFunctionBase {
        private static final long serialVersionUID = 1L;
        private final ArrayData.ElementGetter elementGetter;

        public CollectionUnnestWithOrdinalityFunction(SpecializedFunction.SpecializedContext context, LogicalType elementType, ArrayData.ElementGetter elementGetter) {
            super(context, elementType, true);
            this.elementGetter = elementGetter;
        }

        public void eval(ArrayData arrayData) {
            this.evalArrayData(arrayData, this.elementGetter, this::collectWithOrdinality);
        }

        public void eval(MapData mapData) {
            this.evalMultisetData(mapData, this.elementGetter, this::collectWithOrdinality);
        }

        private void collectWithOrdinality(Object element, int position) {
            if (element instanceof RowData) {
                RowData row = (RowData)element;
                this.collect(new JoinedRowData(row.getRowKind(), row, (RowData)GenericRowData.of((Object[])new Object[]{position})));
            } else {
                this.collect(GenericRowData.of((Object[])new Object[]{element, position}));
            }
        }
    }
}

