/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.metrics.otel;

import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporterBuilder;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.internal.export.MetricProducer;
import java.time.Clock;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.metrics.CharacterFilter;
import org.apache.flink.metrics.Counter;
import org.apache.flink.metrics.Gauge;
import org.apache.flink.metrics.Histogram;
import org.apache.flink.metrics.LogicalScopeProvider;
import org.apache.flink.metrics.Meter;
import org.apache.flink.metrics.Metric;
import org.apache.flink.metrics.MetricConfig;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.metrics.otel.MetricMetadata;
import org.apache.flink.metrics.otel.OpenTelemetryMetricAdapter;
import org.apache.flink.metrics.otel.OpenTelemetryReporterBase;
import org.apache.flink.metrics.otel.OpenTelemetryReporterOptions;
import org.apache.flink.metrics.otel.VariableNameUtil;
import org.apache.flink.metrics.reporter.MetricReporter;
import org.apache.flink.metrics.reporter.Scheduled;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenTelemetryMetricReporter
extends OpenTelemetryReporterBase
implements MetricReporter,
MetricProducer,
Scheduled {
    private static final Logger LOG = LoggerFactory.getLogger(OpenTelemetryMetricReporter.class);
    private static final String LOGICAL_SCOPE_PREFIX = "flink.";
    private final Map<Gauge<?>, MetricMetadata> gauges = new HashMap();
    private final Map<Counter, MetricMetadata> counters = new HashMap<Counter, MetricMetadata>();
    private final Map<Histogram, MetricMetadata> histograms = new HashMap<Histogram, MetricMetadata>();
    private final Map<Meter, MetricMetadata> meters = new HashMap<Meter, MetricMetadata>();
    private final Clock clock;
    private Map<Metric, Long> lastValueSnapshots = Collections.emptyMap();
    private long lastCollectTimeNanos = 0L;
    @Nullable
    private CompletableResultCode lastResult;

    public OpenTelemetryMetricReporter() {
        this(Clock.systemUTC());
    }

    @VisibleForTesting
    OpenTelemetryMetricReporter(Clock clock) {
        this.clock = clock;
    }

    @Override
    public void open(MetricConfig metricConfig) {
        LOG.info("Starting OpenTelemetryMetricReporter");
        super.open(metricConfig);
        OtlpGrpcMetricExporterBuilder builder = OtlpGrpcMetricExporter.builder();
        OpenTelemetryReporterOptions.tryConfigureEndpoint(metricConfig, builder::setEndpoint);
        OpenTelemetryReporterOptions.tryConfigureTimeout(metricConfig, builder::setTimeout);
        this.exporter = builder.build();
    }

    public void close() {
        this.exporter.flush();
        this.waitForLastReportToComplete();
        this.exporter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyOfAddedMetric(Metric metric, String metricName, MetricGroup group) {
        String name = LOGICAL_SCOPE_PREFIX + LogicalScopeProvider.castFrom((MetricGroup)group).getLogicalScope(CharacterFilter.NO_OP_FILTER) + "." + metricName;
        Map<String, String> variables = group.getAllVariables().entrySet().stream().collect(Collectors.toMap(e -> VariableNameUtil.getVariableName((String)e.getKey()), Map.Entry::getValue));
        LOG.debug("Adding metric {} with variables {}", (Object)metricName, variables);
        MetricMetadata metricMetadata = new MetricMetadata(name, variables);
        OpenTelemetryMetricReporter openTelemetryMetricReporter = this;
        synchronized (openTelemetryMetricReporter) {
            switch (metric.getMetricType()) {
                case COUNTER: {
                    this.counters.put((Counter)metric, metricMetadata);
                    break;
                }
                case GAUGE: {
                    this.gauges.put((Gauge)metric, metricMetadata);
                    break;
                }
                case HISTOGRAM: {
                    this.histograms.put((Histogram)metric, metricMetadata);
                    break;
                }
                case METER: {
                    this.meters.put((Meter)metric, metricMetadata);
                    break;
                }
                default: {
                    LOG.warn("Cannot add unknown metric type {}. This indicates that the reporter does not support this metric type.", (Object)metric.getClass().getName());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyOfRemovedMetric(Metric metric, String metricName, MetricGroup group) {
        OpenTelemetryMetricReporter openTelemetryMetricReporter = this;
        synchronized (openTelemetryMetricReporter) {
            this.lastValueSnapshots.remove(metric);
            switch (metric.getMetricType()) {
                case COUNTER: {
                    this.counters.remove((Counter)metric);
                    break;
                }
                case GAUGE: {
                    this.gauges.remove((Gauge)metric);
                    break;
                }
                case HISTOGRAM: {
                    this.histograms.remove((Histogram)metric);
                    break;
                }
                case METER: {
                    this.meters.remove((Meter)metric);
                    break;
                }
                default: {
                    LOG.warn("Cannot remove unknown metric type {}. This indicates that the reporter does not support this metric type.", (Object)metric.getClass().getName());
                }
            }
        }
    }

    private long getCurrentTimeNanos() {
        Instant now = this.clock.instant();
        return TimeUnit.SECONDS.toNanos(now.getEpochSecond()) + (long)now.getNano();
    }

    @Override
    public synchronized Collection<MetricData> collectAllMetrics() {
        Optional<MetricData> metricData;
        MetricMetadata metricMetadata;
        Long lastCount;
        Long count;
        long currentTimeNanos = this.getCurrentTimeNanos();
        ArrayList<MetricData> data = new ArrayList<MetricData>();
        OpenTelemetryMetricAdapter.CollectionMetadata collectionMetadata = new OpenTelemetryMetricAdapter.CollectionMetadata(this.resource, this.lastCollectTimeNanos, currentTimeNanos);
        Map<Metric, Long> currentValueSnapshots = this.takeLastValueSnapshots();
        for (Counter counter : this.counters.keySet()) {
            count = currentValueSnapshots.get(counter);
            lastCount = this.lastValueSnapshots.getOrDefault(counter, 0L);
            MetricMetadata metricMetadata2 = this.counters.get(counter);
            Optional<MetricData> metricData2 = OpenTelemetryMetricAdapter.convertCounter(collectionMetadata, count, lastCount, metricMetadata2);
            metricData2.ifPresent(data::add);
        }
        for (Gauge gauge : this.gauges.keySet()) {
            metricMetadata = this.gauges.get(gauge);
            metricData = OpenTelemetryMetricAdapter.convertGauge(collectionMetadata, gauge, metricMetadata);
            metricData.ifPresent(data::add);
        }
        for (Meter meter : this.meters.keySet()) {
            count = currentValueSnapshots.get(meter);
            lastCount = this.lastValueSnapshots.getOrDefault(meter, 0L);
            MetricMetadata metricMetadata2 = this.meters.get(meter);
            List<MetricData> metricData2 = OpenTelemetryMetricAdapter.convertMeter(collectionMetadata, meter, count, lastCount, metricMetadata2);
            data.addAll(metricData2);
        }
        for (Histogram histogram : this.histograms.keySet()) {
            metricMetadata = this.histograms.get(histogram);
            metricData = OpenTelemetryMetricAdapter.convertHistogram(collectionMetadata, histogram, metricMetadata);
            metricData.ifPresent(data::add);
        }
        this.lastValueSnapshots = currentValueSnapshots;
        this.lastCollectTimeNanos = currentTimeNanos;
        return data;
    }

    private Map<Metric, Long> takeLastValueSnapshots() {
        HashMap<Metric, Long> map = new HashMap<Metric, Long>();
        for (Counter counter : this.counters.keySet()) {
            map.put((Metric)counter, counter.getCount());
        }
        for (Meter meter : this.meters.keySet()) {
            map.put((Metric)meter, meter.getCount());
        }
        return map;
    }

    public void report() {
        Collection<MetricData> metricData = this.collectAllMetrics();
        try {
            this.lastResult = this.exporter.export(metricData);
            this.lastResult.whenComplete(() -> {
                if (this.lastResult.isSuccess()) {
                    LOG.debug("Exported {} metrics using {}", (Object)metricData.size(), (Object)this.exporter.getClass().getName());
                } else {
                    LOG.warn("Failed to export {} metrics using {}", (Object)metricData.size(), (Object)this.exporter.getClass().getName());
                }
            });
        }
        catch (Exception e) {
            LOG.error("Failed to call export for {} metrics using {}", (Object)metricData.size(), (Object)this.exporter.getClass().getName());
        }
    }

    @VisibleForTesting
    void waitForLastReportToComplete() {
        if (this.lastResult != null) {
            this.lastResult.join(1L, TimeUnit.MINUTES);
        }
    }
}

