/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.functions.inference;

import java.util.AbstractList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.catalog.DataTypeFactory;
import org.apache.flink.table.functions.FunctionDefinition;
import org.apache.flink.table.planner.calcite.FlinkOperatorBinding;
import org.apache.flink.table.planner.calcite.FlinkTypeFactory;
import org.apache.flink.table.planner.functions.inference.AbstractSqlCallContext;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.utils.TypeConversions;

@Internal
public final class CallBindingCallContext
extends AbstractSqlCallContext {
    private final List<SqlNode> adaptedArguments;
    private final List<DataType> argumentDataTypes;
    private final SqlOperatorBinding binding;
    @Nullable
    private final DataType outputType;

    public CallBindingCallContext(DataTypeFactory dataTypeFactory, FunctionDefinition definition, SqlCallBinding sqlCallBinding, @Nullable RelDataType outputType) {
        super(dataTypeFactory, definition, sqlCallBinding.getOperator().getNameAsId().toString(), sqlCallBinding.getGroupCount() > 0);
        this.adaptedArguments = sqlCallBinding.operands();
        this.binding = new FlinkOperatorBinding(sqlCallBinding);
        this.argumentDataTypes = new AbstractList<DataType>(){

            @Override
            public DataType get(int pos) {
                LogicalType logicalType = FlinkTypeFactory.toLogicalType(CallBindingCallContext.this.binding.getOperandType(pos));
                return TypeConversions.fromLogicalToDataType((LogicalType)logicalType);
            }

            @Override
            public int size() {
                return CallBindingCallContext.this.binding.getOperandCount();
            }
        };
        this.outputType = CallBindingCallContext.convertOutputType(sqlCallBinding, outputType);
    }

    public boolean isArgumentLiteral(int pos) {
        return SqlUtil.isLiteral(this.adaptedArguments.get(pos), false);
    }

    public boolean isArgumentNull(int pos) {
        return SqlUtil.isNullLiteral(this.adaptedArguments.get(pos), false);
    }

    public <T> Optional<T> getArgumentValue(int pos, Class<T> clazz) {
        if (this.isArgumentNull(pos)) {
            return Optional.empty();
        }
        try {
            SqlLiteral literal = SqlLiteral.unchain(this.adaptedArguments.get(pos));
            return Optional.ofNullable(CallBindingCallContext.getLiteralValueAs(literal::getValueAs, clazz));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public List<DataType> getArgumentDataTypes() {
        return this.argumentDataTypes;
    }

    public Optional<DataType> getOutputDataType() {
        return Optional.ofNullable(this.outputType);
    }

    @Nullable
    private static DataType convertOutputType(SqlCallBinding binding, @Nullable RelDataType returnType) {
        if (returnType == null || returnType.equals(binding.getValidator().getUnknownType()) || returnType.getSqlTypeName() == SqlTypeName.ANY) {
            return null;
        }
        LogicalType logicalType = FlinkTypeFactory.toLogicalType(returnType);
        return TypeConversions.fromLogicalToDataType((LogicalType)logicalType);
    }
}

