/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.aggregation.datasketches.hll;

import java.nio.ByteBuffer;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.datasketches.hll.HllSketch;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringEncoding;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.UOE;
import org.apache.druid.segment.DimensionDictionarySelector;

public class HllSketchBuildUtil {
    public static void updateSketch(HllSketch sketch, StringEncoding stringEncoding, Object value) {
        if (value instanceof Integer || value instanceof Long) {
            sketch.update(((Number)value).longValue());
        } else if (value instanceof Float || value instanceof Double) {
            sketch.update(((Number)value).doubleValue());
        } else if (value instanceof String) {
            HllSketchBuildUtil.updateSketchWithString(sketch, stringEncoding, (String)value);
        } else if (value instanceof List) {
            for (Object entry : (List)value) {
                if (entry == null) continue;
                HllSketchBuildUtil.updateSketchWithString(sketch, stringEncoding, entry.toString());
            }
        } else if (value instanceof char[]) {
            sketch.update((char[])value);
        } else if (value instanceof byte[]) {
            sketch.update((byte[])value);
        } else if (value instanceof int[]) {
            sketch.update((int[])value);
        } else if (value instanceof long[]) {
            sketch.update((long[])value);
        } else {
            throw new IAE("Unsupported type " + value.getClass(), new Object[0]);
        }
    }

    public static void updateSketchWithDictionarySelector(HllSketch sketch, StringEncoding stringEncoding, DimensionDictionarySelector selector, int id) {
        if (stringEncoding == StringEncoding.UTF8 && selector.supportsLookupNameUtf8()) {
            ByteBuffer buf = selector.lookupNameUtf8(id);
            if (buf != null) {
                sketch.update(buf);
            }
        } else {
            HllSketchBuildUtil.updateSketchWithString(sketch, stringEncoding, selector.lookupName(id));
        }
    }

    private static void updateSketchWithString(HllSketch sketch, StringEncoding stringEncoding, @Nullable String value) {
        if (value == null) {
            return;
        }
        switch (stringEncoding) {
            case UTF8: {
                sketch.update(StringUtils.toUtf8((String)value));
                break;
            }
            case UTF16LE: {
                sketch.update(value.toCharArray());
                break;
            }
            default: {
                throw new UOE("Unsupported string encoding [%s]", new Object[]{stringEncoding});
            }
        }
    }
}

