/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.expressions;

import java.util.List;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.math.expr.ExpressionType;

public class SleepExprMacro
implements ExprMacroTable.ExprMacro {
    private static final String NAME = "sleep";

    public String name() {
        return NAME;
    }

    public Expr apply(List<Expr> args) {
        this.validationHelperCheckArgumentCount(args, 1);
        final Expr arg = args.get(0);
        class SleepExpr
        extends ExprMacroTable.BaseScalarMacroFunctionExpr {
            public SleepExpr(List<Expr> args) {
                super((ExprMacroTable.ExprMacro)this$0, args);
            }

            public ExprEval eval(Expr.ObjectBinding bindings) {
                ExprEval eval = arg.eval(bindings);
                try {
                    double seconds;
                    if (!eval.isNumericNull() && (seconds = eval.asDouble()) > 0.0) {
                        Thread.sleep((long)(seconds * 1000.0));
                    }
                    return ExprEval.ofMissing();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw this.processingFailed(e, "interrupted", new Object[0]);
                }
            }

            public boolean canVectorize(Expr.InputBindingInspector inspector) {
                return false;
            }

            public ExpressionType getOutputType(Expr.InputBindingInspector inspector) {
                return null;
            }
        }
        return new SleepExpr(args);
    }
}

