/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.data.input.azure;

import com.azure.storage.blob.models.BlobStorageException;
import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterators;
import java.net.URI;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputEntity;
import org.apache.druid.data.input.InputSplit;
import org.apache.druid.data.input.azure.AzureEntity;
import org.apache.druid.data.input.azure.AzureEntityFactory;
import org.apache.druid.data.input.impl.CloudObjectInputSource;
import org.apache.druid.data.input.impl.CloudObjectLocation;
import org.apache.druid.data.input.impl.CloudObjectSplitWidget;
import org.apache.druid.data.input.impl.SplittableInputSource;
import org.apache.druid.data.input.impl.systemfield.SystemField;
import org.apache.druid.data.input.impl.systemfield.SystemFields;
import org.apache.druid.guice.annotations.Global;
import org.apache.druid.storage.azure.AzureCloudBlobIterableFactory;
import org.apache.druid.storage.azure.AzureInputDataConfig;
import org.apache.druid.storage.azure.AzureStorage;

public class AzureInputSource
extends CloudObjectInputSource {
    public static final String SCHEME = "azure";
    private final AzureStorage storage;
    private final AzureEntityFactory entityFactory;
    private final AzureCloudBlobIterableFactory azureCloudBlobIterableFactory;
    private final AzureInputDataConfig inputDataConfig;

    @JsonCreator
    public AzureInputSource(@JacksonInject @Global AzureStorage storage, @JacksonInject AzureEntityFactory entityFactory, @JacksonInject AzureCloudBlobIterableFactory azureCloudBlobIterableFactory, @JacksonInject AzureInputDataConfig inputDataConfig, @JsonProperty(value="uris") @Nullable List<URI> uris, @JsonProperty(value="prefixes") @Nullable List<URI> prefixes, @JsonProperty(value="objects") @Nullable List<CloudObjectLocation> objects, @JsonProperty(value="objectGlob") @Nullable String objectGlob, @JsonProperty(value="systemFields") @Nullable SystemFields systemFields) {
        super(SCHEME, uris, prefixes, objects, objectGlob, systemFields);
        this.storage = (AzureStorage)Preconditions.checkNotNull((Object)storage, (Object)"AzureStorage");
        this.entityFactory = (AzureEntityFactory)Preconditions.checkNotNull((Object)entityFactory, (Object)"AzureEntityFactory");
        this.azureCloudBlobIterableFactory = (AzureCloudBlobIterableFactory)Preconditions.checkNotNull((Object)azureCloudBlobIterableFactory, (Object)"AzureCloudBlobIterableFactory");
        this.inputDataConfig = (AzureInputDataConfig)Preconditions.checkNotNull((Object)inputDataConfig, (Object)"AzureInputDataConfig");
    }

    @JsonIgnore
    @Nonnull
    public Set<String> getTypes() {
        return Collections.singleton(SCHEME);
    }

    public SplittableInputSource<List<CloudObjectLocation>> withSplit(InputSplit<List<CloudObjectLocation>> split) {
        return new AzureInputSource(this.storage, this.entityFactory, this.azureCloudBlobIterableFactory, this.inputDataConfig, null, null, (List)split.get(), this.getObjectGlob(), this.systemFields);
    }

    public Object getSystemFieldValue(InputEntity entity, SystemField field) {
        AzureEntity googleEntity = (AzureEntity)entity;
        switch (field) {
            case URI: {
                return googleEntity.getUri().toString();
            }
            case BUCKET: {
                return googleEntity.getLocation().getBucket();
            }
            case PATH: {
                return googleEntity.getLocation().getPath();
            }
        }
        return null;
    }

    protected AzureEntity createEntity(CloudObjectLocation location) {
        return this.entityFactory.create(location, this.storage, SCHEME);
    }

    protected CloudObjectSplitWidget getSplitWidget() {
        class SplitWidget
        implements CloudObjectSplitWidget {
            SplitWidget() {
            }

            public Iterator<CloudObjectSplitWidget.LocationWithSize> getDescriptorIteratorForPrefixes(List<URI> prefixes) {
                return Iterators.transform(AzureInputSource.this.azureCloudBlobIterableFactory.create(AzureInputSource.this.getPrefixes(), AzureInputSource.this.inputDataConfig.getMaxListingLength(), AzureInputSource.this.storage).iterator(), blob -> {
                    try {
                        return new CloudObjectSplitWidget.LocationWithSize(blob.getContainerName(), blob.getName(), blob.getBlobLength());
                    }
                    catch (BlobStorageException e) {
                        throw new RuntimeException(e);
                    }
                });
            }

            public long getObjectSize(CloudObjectLocation location) {
                try {
                    return AzureInputSource.this.storage.getBlockBlobLength(location.getBucket(), location.getPath());
                }
                catch (BlobStorageException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return new SplitWidget();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AzureInputSource that = (AzureInputSource)((Object)o);
        return this.storage.equals(that.storage) && this.entityFactory.equals(that.entityFactory) && this.azureCloudBlobIterableFactory.equals(that.azureCloudBlobIterableFactory) && this.inputDataConfig.equals(that.inputDataConfig);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.storage, this.entityFactory, this.azureCloudBlobIterableFactory, this.inputDataConfig);
    }

    public String toString() {
        return "AzureInputSource{uris=" + this.getUris() + ", prefixes=" + this.getPrefixes() + ", objects=" + this.getObjects() + ", objectGlob=" + this.getObjectGlob() + (String)(this.systemFields.getFields().isEmpty() ? "" : ", systemFields=" + this.systemFields) + "}";
    }
}

