// Licensed to the Apache Software Foundation (ASF) under one
// or more contributor license agreements.  See the NOTICE file
// distributed with this work for additional information
// regarding copyright ownership.  The ASF licenses this file
// to you under the Apache License, Version 2.0 (the
// "License"); you may not use this file except in compliance
// with the License.  You may obtain a copy of the License at
//
//   http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing,
// software distributed under the License is distributed on an
// "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
// KIND, either express or implied.  See the License for the
// specific language governing permissions and limitations
// under the License.

package org.apache.doris.nereids.trees.plans;

/**
 * Types for all Plan in Nereids.
 */
public enum PlanType {
    // special
    GROUP_PLAN,
    UNKNOWN,

    // logical plans
    // logical relations
    LOGICAL_SQL_CACHE,
    LOGICAL_BOUND_RELATION,
    LOGICAL_CTE_CONSUMER,
    LOGICAL_FILE_SCAN,
    LOGICAL_EMPTY_RELATION,
    LOGICAL_ES_SCAN,
    LOGICAL_JDBC_SCAN,
    LOGICAL_ODBC_SCAN,
    LOGICAL_OLAP_SCAN,
    LOGICAL_TEST_SCAN,
    LOGICAL_ONE_ROW_RELATION,
    LOGICAL_SCHEMA_SCAN,
    LOGICAL_TVF_RELATION,
    LOGICAL_UNBOUND_ONE_ROW_RELATION,
    LOGICAL_UNBOUND_RELATION,
    LOGICAL_UNBOUND_TVF_RELATION,
    LOGICAL_UNBOUND_INLINE_TABLE,

    // logical sinks
    LOGICAL_FILE_SINK,
    LOGICAL_OLAP_TABLE_SINK,
    LOGICAL_HIVE_TABLE_SINK,
    LOGICAL_ICEBERG_TABLE_SINK,
    LOGICAL_JDBC_TABLE_SINK,
    LOGICAL_RESULT_SINK,
    LOGICAL_DICTIONARY_SINK,
    LOGICAL_UNBOUND_OLAP_TABLE_SINK,
    LOGICAL_UNBOUND_HIVE_TABLE_SINK,
    LOGICAL_UNBOUND_ICEBERG_TABLE_SINK,
    LOGICAL_UNBOUND_JDBC_TABLE_SINK,
    LOGICAL_UNBOUND_RESULT_SINK,
    LOGICAL_UNBOUND_DICTIONARY_SINK,

    // logical others
    LOGICAL_AGGREGATE,
    LOGICAL_APPLY,
    LOGICAL_ASSERT_NUM_ROWS,
    LOGICAL_CHECK_POLICY,
    LOGICAL_COMMON_HINT,
    LOGICAL_CTE,
    LOGICAL_CTE_ANCHOR,
    LOGICAL_CTE_PRODUCER,
    LOGICAL_EXCEPT,
    LOGICAL_FILTER,
    LOGICAL_GENERATE,
    LOGICAL_HAVING,
    LOGICAL_INLINE_TABLE,
    LOGICAL_INTERSECT,
    LOGICAL_JOIN,
    LOGICAL_LIMIT,
    LOGICAL_MULTI_JOIN,
    LOGICAL_PARTITION_TOP_N,
    LOGICAL_PROJECT,
    LOGICAL_QUALIFY,
    LOGICAL_REPEAT,
    LOGICAL_SELECT_HINT,
    LOGICAL_SUBQUERY_ALIAS,
    LOGICAL_VIEW,
    LOGICAL_SORT,
    LOGICAL_TOP_N,
    LOGICAL_UNION,
    LOGICAL_USING_JOIN,
    LOGICAL_WINDOW,

    // physical plans
    // physical relations
    PHYSICAL_SQL_CACHE,
    PHYSICAL_CTE_CONSUMER,
    PHYSICAL_EMPTY_RELATION,
    PHYSICAL_ES_SCAN,
    PHYSICAL_FILE_SCAN,
    PHYSICAL_HUDI_SCAN,
    PHYSICAL_JDBC_SCAN,
    PHYSICAL_ODBC_SCAN,
    PHYSICAL_ONE_ROW_RELATION,
    PHYSICAL_OLAP_SCAN,
    PHYSICAL_SCHEMA_SCAN,
    PHYSICAL_TVF_RELATION,

    // physical sinks
    PHYSICAL_FILE_SINK,
    PHYSICAL_OLAP_TABLE_SINK,
    PHYSICAL_HIVE_TABLE_SINK,
    PHYSICAL_ICEBERG_TABLE_SINK,
    PHYSICAL_JDBC_TABLE_SINK,
    PHYSICAL_RESULT_SINK,
    PHYSICAL_DICTIONARY_SINK,

    // physical others
    PHYSICAL_HASH_AGGREGATE,
    PHYSICAL_ASSERT_NUM_ROWS,
    PHYSICAL_CTE_PRODUCER,
    PHYSICAL_CTE_ANCHOR,
    PHYSICAL_DISTRIBUTE,
    PHYSICAL_EXCEPT,
    PHYSICAL_FILTER,
    PHYSICAL_GENERATE,
    PHYSICAL_INTERSECT,
    PHYSICAL_HASH_JOIN,
    PHYSICAL_NESTED_LOOP_JOIN,
    PHYSICAL_LIMIT,
    PHYSICAL_PARTITION_TOP_N,
    PHYSICAL_PROJECT,
    PHYSICAL_REPEAT,
    PHYSICAL_LOCAL_QUICK_SORT,
    PHYSICAL_QUICK_SORT,
    PHYSICAL_TOP_N,
    PHYSICAL_UNION,
    PHYSICAL_WINDOW,
    PHYSICAL_MATERIALIZE,

    // commands
    ADMIN_CHECK_TABLETS_COMMAND,
    COPY_INTO_COMMAND,
    CREATE_POLICY_COMMAND,
    CREATE_TABLE_COMMAND,
    CREATE_DICTIONARY_COMMAND,
    DROP_DICTIONARY_COMMAND,
    CREATE_SQL_BLOCK_RULE_COMMAND,
    DELETE_COMMAND,
    EXPLAIN_COMMAND,
    EXPLAIN_DICTIONARY_COMMAND,
    EXPORT_COMMAND,
    INSERT_INTO_TABLE_COMMAND,
    INSERT_INTO_DICTIONARY_COMMAND,
    BATCH_INSERT_INTO_TABLE_COMMAND,
    INSERT_OVERWRITE_TABLE_COMMAND,
    LOAD_COMMAND,
    SELECT_INTO_OUTFILE_COMMAND,
    UPDATE_COMMAND,
    CREATE_FUNCTION_COMMAND,
    DROP_FUNCTION_COMMAND,
    CREATE_MTMV_COMMAND,
    CREATE_MATERIALIZED_VIEW_COMMAND,
    CREATE_JOB_COMMAND,
    ALTER_JOB_COMMAND,
    PAUSE_JOB_COMMAND,
    CANCEL_JOB_COMMAND,
    DROP_CATALOG_COMMAND,
    DROP_DATABASE_COMMAND,
    DROP_JOB_COMMAND,
    RESUME_JOB_COMMAND,
    ALTER_MTMV_COMMAND,
    ALTER_CATALOG_PROPERTIES_COMMAND,
    ADD_CONSTRAINT_COMMAND,
    ADMIN_COMPACT_TABLE_COMMAND,
    DROP_CONSTRAINT_COMMAND,
    SHOW_CONSTRAINTS_COMMAND,
    REFRESH_MTMV_COMMAND,
    DROP_MTMV_COMMAND,
    PAUSE_MTMV_COMMAND,
    RESUME_MTMV_COMMAND,
    SHOW_CREATE_MTMV_COMMAND,
    CANCEL_EXPORT_COMMAND,
    CANCEL_LOAD_COMMAND,
    CANCEL_WARM_UP_JOB_COMMAND,
    CANCEL_MTMV_TASK_COMMAND,
    CALL_COMMAND,
    CREATE_PROCEDURE_COMMAND,
    DROP_PROCEDURE_COMMAND,
    DROP_ROLE_COMMAND,
    DROP_REPOSITOORY_COMMAND,
    SHOW_PROCEDURE_COMMAND,
    SHOW_CREATE_PROCEDURE_COMMAND,
    CREATE_VIEW_COMMAND,
    CREATE_WORKLOAD_POLICY_COMMAND,
    CLEAN_ALL_PROFILE_COMMAND,
    CLEAN_TRASH_COMMAND,
    CLEAN_LABEL_COMMAND,
    CREATE_ROLE_COMMAND,
    CREATE_DATABASE_COMMAND,
    CREATE_REPOSITORY_COMMAND,
    CREATE_STORAGE_VAULT_COMMAND,
    ALTER_CATALOG_RENAME_COMMAND,
    ALTER_ROLE_COMMAND,
    ALTER_VIEW_COMMAND,
    ALTER_STORAGE_POLICY_COMMAND,
    ALTER_STORAGE_VAULT,
    ALTER_WORKLOAD_GROUP_COMMAND,
    ALTER_WORKLOAD_POLICY_COMMAND,
    ALTER_DATABASE_RENAME_COMMAND,
    ALTER_DATABASE_SET_DATA_QUOTA_COMMAND,
    DROP_CATALOG_RECYCLE_BIN_COMMAND,
    DROP_ENCRYPTKEY_COMMAND,
    DROP_FILE_COMMAND,
    LOCK_TABLES_COMMAND,
    UNLOCK_TABLES_COMMAND,
    UNSET_VARIABLE_COMMAND,
    UNSET_DEFAULT_STORAGE_VAULT_COMMAND,
    UNSUPPORTED_COMMAND,
    UNSUPPORTED_START_TRANSACTION_COMMAND,
    CREATE_TABLE_LIKE_COMMAND,
    SET_OPTIONS_COMMAND,
    SET_TRANSACTION_COMMAND,
    SET_USER_PROPERTIES_COMMAND,
    SET_DEFAULT_STORAGE_VAULT_COMMAND,
    REFRESH_CATALOG_COMMAND,
    REFRESH_DATABASE_COMMAND,
    REFRESH_TABLE_COMMAND,
    REFRESH_DICTIONARY_COMMAND,
    REFRESH_LDAP_COMMAND,
    ALTER_TABLE_COMMAND,
    OPTIMIZE_TABLE_COMMAND,
    PREPARED_COMMAND,
    EXECUTE_COMMAND,
    DROP_SQL_BLOCK_RULE_COMMAND,
    DROP_USER_COMMAND,
    DROP_STORAGE_POLICY_COMMAND,
    DROP_WORKLOAD_GROUP_NAME,
    DROP_WORKLOAD_POLICY_COMMAND,
    ADMIN_SET_TABLE_STATUS_COMMAND,
    ADMIN_SET_PARTITION_VERSION_COMMAND,
    ALTER_CATALOG_COMMENT_COMMAND,
    ALTER_SQL_BLOCK_RULE_COMMAND,
    ALTER_REPOSITORY_COMMAND,
    ALTER_RESOURCE_COMMAND,
    SHOW_ANALYZE_COMMAND,
    SHOW_QUEUED_ANALYZE_JOBS_COMMAND,
    SHOW_ANALYZE_TASK_COMMAND,
    SHOW_BACKENDS_COMMAND,
    SHOW_BACKUP_COMMAND,
    SHOW_BLOCK_RULE_COMMAND,
    SHOW_BROKER_COMMAND,
    SHOW_BUILD_INDEX_COMMAND,
    SHOW_CATALOG_COMMAND,
    SHOW_CATALOG_RECYCLE_BIN_COMMAND,
    SHOW_CHARSET_COMMAND,
    SHOW_CLUSTERS_COMMAND,
    SHOW_COLLATION_COMMAND,
    SHOW_COLUMN_HISTOGRAM,
    SHOW_COLUMNS_COMMAND,
    SHOW_COLUMN_STATS_COMMAND,
    SHOW_CONFIG_COMMAND,
    SHOW_CREATE_CATALOG_COMMAND,
    SHOW_CREATE_DATABASE_COMMAND,
    SHOW_CREATE_FUNCTION_COMMAND,
    SHOW_CREATE_LOAD_COMMAND,
    SHOW_CREATE_MATERIALIZED_VIEW_COMMAND,
    SHOW_CREATE_REPOSITORY_COMMAND,
    SHOW_CREATE_TABLE_COMMAND,
    SHOW_CREATE_VIEW_COMMAND,
    SHOW_CREATE_USER_COMMAND,
    SHOW_DATABASES_COMMAND,
    SHOW_DATABASE_ID_COMMAND,
    SHOW_DATA_COMMAND,
    SHOW_DATA_SKEW_COMMAND,
    SHOW_DELETE_COMMAND,
    SHOW_DIAGNOSE_TABLET_COMMAND,
    SHOW_DYNAMIC_PARTITION_COMMAND,
    SHOW_ENCRYPT_KEYS_COMMAND,
    SHOW_EVENTS_COMMAND,
    SHOW_EXPORT_COMMAND,
    SHOW_DATA_TYPES_COMMAND,
    SHOW_FRONTENDS_COMMAND,
    SHOW_FUNCTIONS_COMMAND,
    SHOW_GLOBAL_FUNCTIONS_COMMAND,
    SHOW_GRANTS_COMMAND,
    SHOW_INDEX_COMMAND,
    SHOW_INDEX_STATS_COMMAND,
    SHOW_LAST_INSERT_COMMAND,
    SHOW_LOAD_COMMAND,
    SHOW_LOAD_PROFILE_COMMAND,
    SHOW_LOAD_WARNINGS_COMMAND,
    SHOW_OPEN_TABLES_COMMAND,
    SHOW_PARTITIONID_COMMAND,
    SHOW_PARTITIONS_COMMAND,
    SHOW_PROCESSLIST_COMMAND,
    SHOW_PROC_COMMAND,
    SHOW_PLUGINS_COMMAND,
    SHOW_PRIVILEGES_COMMAND,
    SHOW_REPLICA_DISTRIBUTION_COMMAND,
    SHOW_REPLICA_STATUS_COMMAND,
    SHOW_REPOSITORIES_COMMAND,
    SHOW_RESOURCES_COMMAND,
    SHOW_RESTORE_COMMAND,
    SHOW_ROLE_COMMAND,
    SHOW_ROW_POLICY_COMMAND,
    SHOW_SMALL_FILES_COMMAND,
    SHOW_SNAPSHOT_COMMAND,
    SHOW_STAGES_COMMAND,
    SHOW_STATUS_COMMAND,
    SHOW_STORAGE_ENGINES_COMMAND,
    SHOW_STORAGE_POLICY_COMMAND,
    SHOW_STORAGE_VAULT_COMMAND,
    SHOW_SYNC_JOB_COMMAND,
    SHOW_TABLE_ID_COMMAND,
    SHOW_TABLETS,
    SHOW_TABLES,
    SHOW_TABLES_STATUS,
    SHOW_TABLET_ID_COMMAND,
    SHOW_TRASH_COMMAND,
    SHOW_TABLET_STORAGE_FORMAT_COMMAND,
    SHOW_TRIGGERS_COMMAND,
    SHOW_TYPE_CAST_COMMAND,
    SHOW_VARIABLES_COMMAND,
    SHOW_AUTHORS_COMMAND,
    SHOW_ALTER_TABLE_COMMAND,
    SHOW_USER_PROPERTY_COMMAND,
    SHOW_VIEW_COMMAND,
    SHOW_VIEWS,
    SHOW_WARNING_ERRORS_COMMAND,
    SHOW_WARNING_ERROR_COUNT_COMMAND,
    SHOW_WHITE_LIST_COMMAND,
    SHOW_TABLETS_BELONG_COMMAND,
    SHOW_CONVERT_LSC_COMMAND,
    SHOW_DICTIONARIES_COMMAND,
    SYNC_COMMAND,
    RECOVER_DATABASE_COMMAND,
    RECOVER_TABLE_COMMAND,
    RECOVER_PARTITION_COMMAND,
    SHOW_CREATE_STORAGE_VAULT_COMMAND,
    REPLAY_COMMAND,
    ADMIN_REBALANCE_DISK_COMMAND,
    ADMIN_SET_REPLICA_VERSION_COMMAND,
    ADMIN_CANCEL_REBALANCE_DISK_COMMAND,
    ADMIN_SET_FRONTEND_CONFIG_COMMAND,
    CREATE_ENCRYPTKEY_COMMAND,
    CREATE_WORKLOAD_GROUP_COMMAND,
    CREATE_CATALOG_COMMAND,
    CREATE_FILE_COMMAND,
    CREATE_ROUTINE_LOAD_COMMAND,
    SHOW_TABLE_CREATION_COMMAND,
    SHOW_QUERY_PROFILE_COMMAND,
    SHOW_QUERY_STATS_COMMAND,
    SWITCH_COMMAND,
    HELP_COMMAND,
    INSTALL_PLUGIN_COMMAND,
    USE_COMMAND,
    KILL_QUERY_COMMAND,
    KILL_CONNECTION_COMMAND,
    UNINSTALL_PLUGIN_COMMAND,
    DESCRIBE,
    DROP_TABLE_COMMAND,
    DROP_VIEW_COMMAND,
    ANALYZE_DATABASE,
    ANALYZE_TABLE,
    ALTER_DATABASE_PROPERTIES_COMMAND,
    ALTER_SYSTEM,
    ALTER_SYSTEM_RENAME_COMPUTE_GROUP,
    ALTER_USER_COMMAND,
    ALTER_SYSTEM_ADD_BACKEND,
    ALTER_SYSTEM_DROP_BACKEND,
    ALTER_SYSTEM_DECOMMISSION_BACKEND,
    ALTER_SYSTEM_ADD_OBSERVER,
    ALTER_SYSTEM_DROP_OBSERVER,
    ALTER_SYSTEM_ADD_FOLLOWER,
    ALTER_SYSTEM_DROP_FOLLOWER,
    ALTER_SYSTEM_ADD_BROKER,
    ALTER_SYSTEM_DROP_BROKER,
    ALTER_SYSTEM_DROP_ALL_BROKER,
    ALTER_SYSTEM_SET_LOAD_ERRORS_HU,
    ALTER_SYSTEM_MODIFY_BACKEND,
    ALTER_SYSTEM_MODIFY_FRONTEND_OR_BACKEND_HOSTNAME,
    SHOW_TABLE_STATS_COMMAND,
    DROP_STATS_COMMAND,
    DROP_CACHED_STATS_COMMAND,
    DROP_EXPIRED_STATS_COMMAND,
    ALTER_TABLE_STATS_COMMAND,
    ALTER_COLUMN_STATS_COMMAND,
    MYSQL_LOAD_COMMAND,
    CANCEL_ALTER_TABLE_COMMAND,
    ADMIN_REPAIR_TAVLE_COMMAND,
    ADMIN_SET_REPLICA_STATUS_COMMAND,
    ADMIN_SET_ENCRYPTION_ROOT_KEY_COMMAND,
    USE_CLOUD_CLUSTER_COMMAND,
    ADMIN_CANCEL_REPAIR_TABLE_COMMAND,
    ADMIN_COPY_TABLET_COMMAND,
    ADMIN_CREATE_CLUSTER_SNAPSHOT_COMMAND,
    ADMIN_SET_AUTO_CLUSTER_SNAPSHOT_COMMAND,
    ADMIN_SET_CLUSTER_SNAPSHOT_FEATURE_SWITCH_COMMAND,
    ADMIN_DROP_CLUSTER_SNAPSHOT_COMMAND,
    ADMIN_ROTATE_TDE_ROOT_KEY,
    SHOW_CREATE_ROUTINE_LOAD_COMMAND,
    PAUSE_ROUTINE_LOAD_COMMAND,
    PAUSE_ALL_ROUTINE_COMMAND,
    RESUME_ROUTINE_LOAD_COMMAND,
    RESUME_ALL_ROUTINE_COMMAND,
    STOP_ROUTINE_LOAD_COMMAND,
    CLEAN_QUERY_STATS_COMMAND,
    PAUSE_DATA_SYNC_JOB_COMMAND,
    RESUME_DATA_SYNC_JOB_COMMAND,
    STOP_DATA_SYNC_JOB_COMMAND,
    DROP_RESOURCE_COMMAND,
    DROP_ROW_POLICY_COMMAND,
    TRANSACTION_BEGIN_COMMAND,
    TRANSACTION_COMMIT_COMMAND,
    TRANSACTION_ROLLBACK_COMMAND,
    KILL_ANALYZE_JOB_COMMAND,
    DROP_ANALYZE_JOB_COMMAND,
    ALTER_ROUTINE_LOAD_COMMAND,
    ALTER_COLOCATE_GROUP_COMMAND,
    CREATE_USER_COMMAND,
    WARM_UP_CLUSTER_COMMAND,
    CANCEL_BACKUP_AND_RESTORE_COMMAND,
    CANCEL_BUILD_INDEX_COMMAND,
    CREATE_RESOURCE_COMMAND,
    RESTORE_COMMAND,
    BACKUP_COMMAND,
    CREATE_DATA_SYNC_JOB_COMMAND,
    CREATE_STAGE_COMMAND,
    DROP_STAGE_COMMAND,
    CANCEL_DECOMMISSION_BACKEND_COMMAND,
    SHOW_TRANSACTION_COMMAND,
    SHOW_WORKLOAD_GROUP_COMMAND,
    TRUNCATE_TABLE_COMMAND,
    GRANT_ROLE_COMMAND,
    GRANT_RESOURCE_PRIVILEGE_COMMAND,
    GRANT_TABLE_PRIVILEGE_COMMAND,
    REVOKE_TABLE_PRIVILEGE_COMMAND,
    REVOKE_ROLE_COMMAND,
    SHOW_ROUTINE_LOAD_COMMAND,
    SHOW_ROUTINE_LOAD_TASK_COMMAND,
    SHOW_WARM_UP_COMMAND,
    REVOKE_RESOURCE_PRIVILEGE_COMMAND,
    CREATE_INDEX_ANALYZER_COMMAND,
    CREATE_INDEX_TOKENIZER_COMMAND,
    CREATE_INDEX_TOKEN_FILTER_COMMAND,
    DROP_INDEX_ANALYZER_COMMAND,
    DROP_INDEX_TOKENIZER_COMMAND,
    DROP_INDEX_TOKEN_FILTER_COMMAND,
    SHOW_INDEX_ANALYZER_COMMAND,
    SHOW_INDEX_TOKENIZER_COMMAND,
    SHOW_INDEX_TOKEN_FILTER_COMMAND,
    DROP_MATERIALIZED_VIEW_COMMAND,
    CREATE_INDEX_CHAR_FILTER_COMMAND,
    DROP_INDEX_CHAR_FILTER_COMMAND,
    SHOW_INDEX_CHAR_FILTER_COMMAND,
    EMPTY_COMMAND
}
