/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.rest;

import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.directory.fortress.core.DelAccessMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.model.FortRequest;
import org.apache.directory.fortress.core.model.FortResponse;
import org.apache.directory.fortress.core.model.Permission;
import org.apache.directory.fortress.core.model.Role;
import org.apache.directory.fortress.core.model.RolePerm;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.model.UserAdminRole;
import org.apache.directory.fortress.core.model.UserRole;
import org.apache.directory.fortress.core.rest.AccessMgrRestImpl;
import org.apache.directory.fortress.core.rest.RestUtils;
import org.apache.directory.fortress.core.util.VUtil;

public class DelAccessMgrRestImpl
extends AccessMgrRestImpl
implements DelAccessMgr {
    private static final String CLS_NM = DelAccessMgrRestImpl.class.getName();

    @Override
    public boolean canAssign(Session session, User user, Role role) throws SecurityException {
        String methodName = CLS_NM + ".canAssign";
        VUtil.assertNotNull(session, 1030, methodName);
        VUtil.assertNotNull(user, 1008, methodName);
        VUtil.assertNotNull(role, 5007, methodName);
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        UserRole uRole = new UserRole(user.getUserId(), role.getName());
        request.setSession(session);
        request.setEntity(uRole);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "adminAssign");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        boolean result = response.getAuthorized();
        Session outSession = response.getSession();
        session.copy(outSession);
        return result;
    }

    @Override
    public boolean canDeassign(Session session, User user, Role role) throws SecurityException {
        String methodName = CLS_NM + ".canDeassign";
        VUtil.assertNotNull(session, 1030, methodName);
        VUtil.assertNotNull(user, 1008, methodName);
        VUtil.assertNotNull(role, 5007, methodName);
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        UserRole uRole = new UserRole(user.getUserId(), role.getName());
        request.setSession(session);
        request.setEntity(uRole);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "adminDeassign");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        boolean result = response.getAuthorized();
        Session outSession = response.getSession();
        session.copy(outSession);
        return result;
    }

    @Override
    public boolean canGrant(Session session, Role role, Permission perm) throws SecurityException {
        String methodName = CLS_NM + "canGrant";
        VUtil.assertNotNull(session, 1030, methodName);
        VUtil.assertNotNull(perm, 3010, methodName);
        VUtil.assertNotNull(role, 5007, methodName);
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        RolePerm context = new RolePerm();
        context.setPerm(perm);
        context.setRole(role);
        request.setSession(session);
        request.setEntity(context);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "adminGrant");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        boolean result = response.getAuthorized();
        Session outSession = response.getSession();
        session.copy(outSession);
        return result;
    }

    @Override
    public boolean canRevoke(Session session, Role role, Permission perm) throws SecurityException {
        String methodName = CLS_NM + "canRevoke";
        VUtil.assertNotNull(session, 1030, methodName);
        VUtil.assertNotNull(perm, 3010, methodName);
        VUtil.assertNotNull(role, 5007, methodName);
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        RolePerm context = new RolePerm();
        context.setPerm(perm);
        context.setRole(role);
        request.setSession(session);
        request.setEntity(context);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "adminRevoke");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        boolean result = response.getAuthorized();
        Session outSession = response.getSession();
        session.copy(outSession);
        return result;
    }

    @Override
    public boolean checkAccess(Session session, Permission perm) throws SecurityException {
        String methodName = CLS_NM + ".checkAccess";
        VUtil.assertNotNull(perm, 3008, methodName);
        VUtil.assertNotNullOrEmpty(perm.getOpName(), 3009, methodName);
        VUtil.assertNotNullOrEmpty(perm.getObjName(), 3010, methodName);
        VUtil.assertNotNull(session, 1030, methodName);
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setSession(session);
        request.setEntity(perm);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "adminAuthZ");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        boolean result = response.getAuthorized();
        Session outSession = response.getSession();
        session.copy(outSession);
        return result;
    }

    @Override
    public void addActiveRole(Session session, UserAdminRole role) throws SecurityException {
        String methodName = CLS_NM + ".addActiveRole";
        VUtil.assertNotNull(session, 1030, methodName);
        VUtil.assertNotNull(role, 9007, methodName);
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setSession(session);
        request.setEntity(role);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "adminAdd");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        Session outSession = response.getSession();
        session.copy(outSession);
    }

    @Override
    public void dropActiveRole(Session session, UserAdminRole role) throws SecurityException {
        String methodName = CLS_NM + ".dropActiveRole";
        VUtil.assertNotNull(session, 1030, methodName);
        VUtil.assertNotNull(role, 9007, methodName);
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setSession(session);
        request.setEntity(role);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "adminDrop");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        Session outSession = response.getSession();
        session.copy(outSession);
    }

    @Override
    public List<UserAdminRole> sessionAdminRoles(Session session) throws SecurityException {
        VUtil.assertNotNull(session, 1030, CLS_NM + ".sessionAdminRoles");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setSession(session);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "adminRoles");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        List<UserAdminRole> roles = response.getEntities();
        Session outSession = response.getSession();
        session.copy(outSession);
        return roles;
    }

    @Override
    public Set<String> authorizedAdminRoles(Session session) throws SecurityException {
        VUtil.assertNotNull(session, 1030, CLS_NM + ".authorizedAdminRoles");
        TreeSet<String> retRoleNames = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setSession(session);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "adminAuthzRoles");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        Set<String> tempNames = response.getValueSet();
        retRoleNames.addAll(tempNames);
        Session outSession = response.getSession();
        session.copy(outSession);
        return retRoleNames;
    }

    @Override
    public List<Permission> sessionPermissions(Session session) throws SecurityException {
        VUtil.assertNotNull(session, 1030, CLS_NM + ".sessionPermissions");
        FortRequest request = new FortRequest();
        request.setContextId(this.contextId);
        request.setSession(session);
        String szRequest = RestUtils.marshal(request);
        String szResponse = RestUtils.getInstance().post(szRequest, "adminPerms");
        FortResponse response = RestUtils.unmarshall(szResponse);
        if (response.getErrorCode() != 0) {
            throw new SecurityException(response.getErrorCode(), response.getErrorMessage());
        }
        List<Permission> retPerms = response.getEntities();
        Session outSession = response.getSession();
        session.copy(outSession);
        return retPerms;
    }

    @Override
    public boolean canAdd(Session session, User user) throws SecurityException {
        throw new UnsupportedOperationException("not implemented");
    }

    @Override
    public boolean canEdit(Session session, User user) throws SecurityException {
        throw new UnsupportedOperationException("not implemented");
    }
}

