/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.sql.whereclausebuilder;

import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.torque.TorqueException;
import org.apache.torque.adapter.Adapter;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.criteria.PreparedStatementPart;
import org.apache.torque.criteria.SqlEnum;
import org.apache.torque.sql.Query;
import org.apache.torque.sql.WhereClauseExpression;
import org.apache.torque.sql.whereclausebuilder.AbstractWhereClausePsPartBuilder;
import org.apache.torque.sql.whereclausebuilder.CombinedPreparedStatementPart;

public class InBuilder
extends AbstractWhereClausePsPartBuilder {
    @Override
    public PreparedStatementPart buildPs(WhereClauseExpression whereClausePart, boolean ignoreCase, Query query, Adapter adapter) throws TorqueException {
        CombinedPreparedStatementPart result = new CombinedPreparedStatementPart();
        boolean ignoreCaseApplied = false;
        ArrayList<String> inClause = new ArrayList<String>();
        boolean nullContained = false;
        if (whereClausePart.getRValue() instanceof Iterable) {
            for (Object listValue : (Iterable)whereClausePart.getRValue()) {
                if (listValue == null) {
                    nullContained = true;
                    continue;
                }
                result.addPreparedStatementReplacement(listValue);
                if (ignoreCase && listValue instanceof String) {
                    inClause.add(adapter.ignoreCase("?"));
                    ignoreCaseApplied = true;
                    continue;
                }
                inClause.add("?");
            }
        } else if (whereClausePart.getRValue().getClass().isArray()) {
            for (Object arrayValue : (Object[])whereClausePart.getRValue()) {
                if (arrayValue == null) {
                    nullContained = true;
                    continue;
                }
                result.addPreparedStatementReplacement(arrayValue);
                if (ignoreCase && arrayValue instanceof String) {
                    inClause.add(adapter.ignoreCase("?"));
                    ignoreCaseApplied = true;
                    continue;
                }
                inClause.add("?");
            }
        } else {
            throw new IllegalArgumentException("Unknown rValue type " + whereClausePart.getRValue().getClass().getName() + ". rValue must be an instance of  Iterable or Array");
        }
        if (nullContained) {
            result.appendSql("(");
        }
        result.append(InBuilder.getObjectOrColumnPsPartBuilder().buildPs(whereClausePart.getLValue(), ignoreCaseApplied, query, adapter));
        result.appendSql(whereClausePart.getOperator().toString() + "(" + StringUtils.join(inClause.iterator(), (String)",") + ")");
        if (nullContained) {
            if (whereClausePart.getOperator() == SqlEnum.IN) {
                result.appendSql(" OR ");
                result.append(InBuilder.getObjectOrColumnPsPartBuilder().buildPs(whereClausePart.getLValue(), false, query, adapter));
                result.appendSql(SqlEnum.ISNULL.toString());
            } else if (whereClausePart.getOperator() == SqlEnum.NOT_IN) {
                result.appendSql(" AND ");
                result.append(InBuilder.getObjectOrColumnPsPartBuilder().buildPs(whereClausePart.getLValue(), false, query, adapter));
                result.appendSql(SqlEnum.ISNOTNULL.toString());
            }
            result.appendSql(")");
        }
        return result;
    }

    @Override
    public boolean isApplicable(WhereClauseExpression whereClauseExpression, Adapter adapter) {
        return (whereClauseExpression.getOperator().equals(Criteria.IN) || whereClauseExpression.getOperator().equals(Criteria.NOT_IN)) && !(whereClauseExpression.getRValue() instanceof Criteria);
    }
}

