/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.adapter;

import java.lang.invoke.CallSite;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.ListIterator;
import org.apache.torque.adapter.AbstractAdapter;
import org.apache.torque.adapter.IDMethod;
import org.apache.torque.sql.Query;
import org.apache.torque.util.UniqueList;

public class OracleAdapter
extends AbstractAdapter {
    private static final long serialVersionUID = 8966976210230241194L;

    protected OracleAdapter() {
    }

    @Override
    public String toUpperCase(String in) {
        return "UPPER(" + in + ")";
    }

    @Override
    public String ignoreCase(String in) {
        return "UPPER(" + in + ")";
    }

    @Override
    public IDMethod getIDMethodType() {
        return IDMethod.SEQUENCE;
    }

    @Override
    public String getIDMethodSQL(Object sequenceName) {
        return "select " + String.valueOf(sequenceName) + ".nextval from dual";
    }

    @Override
    public void lockTable(Connection con, String table) throws SQLException {
        try (Statement statement = con.createStatement();){
            statement.execute("SELECT * FROM " + table + " FOR UPDATE");
        }
    }

    @Override
    public void unlockTable(Connection con, String table) throws SQLException {
        con.commit();
    }

    @Override
    public void generateLimits(Query query, long offset, int limit) {
        StringBuilder preLimit = new StringBuilder().append("SELECT B.* FROM ( ").append("SELECT A.*, rownum AS TORQUE$ROWNUM FROM ( ");
        StringBuilder postLimit = new StringBuilder().append(" ) A ").append(" ) B WHERE ");
        if (offset > 0L) {
            postLimit.append(" B.TORQUE$ROWNUM > ").append(offset);
            if (limit >= 0) {
                postLimit.append(" AND B.TORQUE$ROWNUM <= ").append(offset + (long)limit);
            }
        } else {
            postLimit.append(" B.TORQUE$ROWNUM <= ").append(limit);
        }
        query.setPreLimit(preLimit.toString());
        query.setPostLimit(postLimit.toString());
        query.setLimit(null);
        UniqueList<String> selectColumns = query.getSelectClause();
        int replacementSuffix = 0;
        HashSet<Object> columnNames = new HashSet<Object>();
        for (String string : selectColumns) {
            int spacePos;
            if (string.indexOf(40) != -1 || string.indexOf(41) != -1 || (spacePos = string.lastIndexOf(32)) == -1) continue;
            String aliasName = string.substring(spacePos + 1);
            columnNames.add(aliasName);
        }
        ListIterator<CallSite> columnIt = selectColumns.listIterator();
        while (columnIt.hasNext()) {
            int spacePos;
            String string = (String)columnIt.next();
            if (string.indexOf(40) != -1 || string.indexOf(41) != -1 || (spacePos = string.lastIndexOf(32)) != -1) continue;
            int dotPos = string.lastIndexOf(46);
            String column = dotPos != -1 ? string.substring(dotPos + 1) : string;
            if (columnNames.contains(column)) {
                String aliasName;
                do {
                    aliasName = "a" + replacementSuffix;
                    ++replacementSuffix;
                } while (columnNames.contains(aliasName));
                String string2 = string + " " + aliasName;
                columnIt.set((CallSite)((Object)string2));
                columnNames.add(aliasName);
                continue;
            }
            columnNames.add(column);
        }
    }

    @Override
    public boolean escapeText() {
        return false;
    }

    @Override
    public boolean useEscapeClauseForLike() {
        return true;
    }

    @Override
    public boolean useMinusForExcept() {
        return true;
    }
}

