/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import java.util.Arrays;
import java.util.Comparator;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.common.Util;
import org.apache.datasketches.quantiles.ItemsUpdateImpl;
import org.apache.datasketches.quantiles.QuantilesItemsSketch;

final class ItemsMergeImpl {
    private ItemsMergeImpl() {
    }

    static <T> void mergeInto(QuantilesItemsSketch<T> src, QuantilesItemsSketch<T> tgt) {
        Object tgtMin;
        long srcBitPattern;
        int srcK = src.getK();
        int tgtK = tgt.getK();
        long srcN = src.getN();
        long tgtN = tgt.getN();
        if (srcK != tgtK) {
            ItemsMergeImpl.downSamplingMergeInto(src, tgt);
            return;
        }
        Object[] srcCombBuf = src.getCombinedBuffer();
        long nFinal = tgtN + srcN;
        for (int i = 0; i < src.getBaseBufferCount(); ++i) {
            tgt.update(srcCombBuf[i]);
        }
        ItemsUpdateImpl.maybeGrowLevels(tgt, nFinal);
        Object[] scratchBuf = new Object[2 * tgtK];
        assert (srcBitPattern == srcN / (2L * (long)srcK));
        int srcLvl = 0;
        for (srcBitPattern = src.getBitPattern(); srcBitPattern != 0L; srcBitPattern >>>= 1) {
            if ((srcBitPattern & 1L) > 0L) {
                ItemsUpdateImpl.inPlacePropagateCarry(srcLvl, srcCombBuf, (2 + srcLvl) * tgtK, scratchBuf, 0, false, tgt);
            }
            ++srcLvl;
        }
        tgt.n_ = nFinal;
        assert (tgt.getN() / (2L * (long)tgtK) == tgt.getBitPattern());
        Object srcMax = src.isEmpty() ? null : (Object)src.getMaxItem();
        Object srcMin = src.isEmpty() ? null : (Object)src.getMinItem();
        Object tgtMax = tgt.isEmpty() ? null : (Object)tgt.getMaxItem();
        Object t = tgtMin = tgt.isEmpty() ? null : (Object)tgt.getMinItem();
        if (srcMax != null && tgtMax != null) {
            tgt.maxItem_ = src.getComparator().compare(srcMax, tgtMax) > 0 ? srcMax : tgtMax;
        } else if (tgtMax == null) {
            tgt.maxItem_ = srcMax;
        }
        if (srcMin != null && tgtMin != null) {
            tgt.minItem_ = src.getComparator().compare(srcMin, tgtMin) > 0 ? tgtMin : srcMin;
        } else if (tgtMin == null) {
            tgt.minItem_ = srcMin;
        }
    }

    static <T> void downSamplingMergeInto(QuantilesItemsSketch<T> src, QuantilesItemsSketch<T> tgt) {
        Object tgtMin;
        int targetK;
        int sourceK = src.getK();
        if (sourceK % (targetK = tgt.getK()) != 0) {
            throw new SketchesArgumentException("source.getK() must equal target.getK() * 2^(nonnegative integer).");
        }
        int downFactor = sourceK / targetK;
        Util.checkIfPowerOf2(downFactor, "source.getK()/target.getK() ratio");
        int lgDownFactor = Integer.numberOfTrailingZeros(downFactor);
        Object[] sourceLevels = src.getCombinedBuffer();
        Object[] sourceBaseBuffer = src.getCombinedBuffer();
        long nFinal = tgt.getN() + src.getN();
        for (int i = 0; i < src.getBaseBufferCount(); ++i) {
            tgt.update(sourceBaseBuffer[i]);
        }
        ItemsUpdateImpl.maybeGrowLevels(tgt, nFinal);
        Object[] scratchBuf = new Object[2 * targetK];
        Object[] downBuf = new Object[targetK];
        int srcLvl = 0;
        for (long srcBitPattern = src.getBitPattern(); srcBitPattern != 0L; srcBitPattern >>>= 1) {
            if ((srcBitPattern & 1L) > 0L) {
                ItemsMergeImpl.justZipWithStride(sourceLevels, (2 + srcLvl) * sourceK, downBuf, 0, targetK, downFactor);
                ItemsUpdateImpl.inPlacePropagateCarry(srcLvl + lgDownFactor, downBuf, 0, scratchBuf, 0, false, tgt);
            }
            ++srcLvl;
        }
        tgt.n_ = nFinal;
        assert (tgt.getN() / (2L * (long)targetK) == tgt.getBitPattern());
        Object srcMax = src.isEmpty() ? null : (Object)src.getMaxItem();
        Object srcMin = src.isEmpty() ? null : (Object)src.getMinItem();
        Object tgtMax = tgt.isEmpty() ? null : (Object)tgt.getMaxItem();
        Object t = tgtMin = tgt.isEmpty() ? null : (Object)tgt.getMinItem();
        if (srcMax != null && tgtMax != null) {
            tgt.maxItem_ = src.getComparator().compare(srcMax, tgtMax) > 0 ? srcMax : tgtMax;
        } else if (tgtMax == null) {
            tgt.maxItem_ = srcMax;
        }
        if (srcMin != null && tgtMin != null) {
            tgt.minItem_ = src.getComparator().compare(srcMin, tgtMin) > 0 ? tgtMin : srcMin;
        } else if (tgtMin == null) {
            tgt.minItem_ = srcMin;
        }
    }

    private static <T> void justZipWithStride(T[] bufSrc, int startSrc, T[] bufC, int startC, int kC, int stride) {
        int randomOffset = QuantilesItemsSketch.rand.nextInt(stride);
        int limC = startC + kC;
        int a = startSrc + randomOffset;
        for (int c = startC; c < limC; ++c) {
            bufC[c] = bufSrc[a];
            a += stride;
        }
    }

    static <T> void blockyTandemMergeSort(T[] quantiles, long[] cumWts, int arrLen, int blkSize, Comparator<? super T> comparator) {
        assert (blkSize >= 1);
        if (arrLen <= blkSize) {
            return;
        }
        int numblks = arrLen / blkSize;
        if (numblks * blkSize < arrLen) {
            ++numblks;
        }
        assert (numblks * blkSize >= arrLen);
        T[] keyTmp = Arrays.copyOf(quantiles, arrLen);
        long[] valTmp = Arrays.copyOf(cumWts, arrLen);
        ItemsMergeImpl.blockyTandemMergeSortRecursion(keyTmp, valTmp, quantiles, cumWts, 0, numblks, blkSize, arrLen, comparator);
    }

    private static <T> void blockyTandemMergeSortRecursion(T[] qSrc, long[] cwSrc, T[] qDst, long[] cwDest, int grpStart, int grpLen, int blkSize, int arrLim, Comparator<? super T> comparator) {
        assert (grpLen > 0);
        if (grpLen == 1) {
            return;
        }
        int grpLen1 = grpLen / 2;
        int grpLen2 = grpLen - grpLen1;
        assert (grpLen1 >= 1);
        assert (grpLen2 >= grpLen1);
        int grpStart1 = grpStart;
        int grpStart2 = grpStart + grpLen1;
        ItemsMergeImpl.blockyTandemMergeSortRecursion(qDst, cwDest, qSrc, cwSrc, grpStart1, grpLen1, blkSize, arrLim, comparator);
        ItemsMergeImpl.blockyTandemMergeSortRecursion(qDst, cwDest, qSrc, cwSrc, grpStart2, grpLen2, blkSize, arrLim, comparator);
        int arrStart1 = grpStart1 * blkSize;
        int arrStart2 = grpStart2 * blkSize;
        int arrLen1 = grpLen1 * blkSize;
        int arrLen2 = grpLen2 * blkSize;
        if (arrStart2 + arrLen2 > arrLim) {
            arrLen2 = arrLim - arrStart2;
        }
        ItemsMergeImpl.tandemMerge(qSrc, cwSrc, arrStart1, arrLen1, arrStart2, arrLen2, qDst, cwDest, arrStart1, comparator);
    }

    private static <T> void tandemMerge(T[] qSrc, long[] cwSrc, int arrStart1, int arrLen1, int arrStart2, int arrLen2, T[] qDst, long[] cwDst, int arrStart3, Comparator<? super T> comparator) {
        int arrStop1 = arrStart1 + arrLen1;
        int arrStop2 = arrStart2 + arrLen2;
        int i1 = arrStart1;
        int i2 = arrStart2;
        int i3 = arrStart3;
        while (i1 < arrStop1 && i2 < arrStop2) {
            if (comparator.compare(qSrc[i2], qSrc[i1]) < 0) {
                qDst[i3] = qSrc[i2];
                cwDst[i3] = cwSrc[i2];
                ++i3;
                ++i2;
                continue;
            }
            qDst[i3] = qSrc[i1];
            cwDst[i3] = cwSrc[i1];
            ++i3;
            ++i1;
        }
        if (i1 < arrStop1) {
            System.arraycopy(qSrc, i1, qDst, i3, arrStop1 - i1);
            System.arraycopy(cwSrc, i1, cwDst, i3, arrStop1 - i1);
        } else {
            assert (i2 < arrStop2);
            System.arraycopy(qSrc, i2, qDst, i3, arrStop2 - i2);
            System.arraycopy(cwSrc, i2, cwDst, i3, arrStop2 - i2);
        }
    }
}

