/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors.parsers;

import org.apache.daffodil.io.InputSourceDataInputStream;
import org.apache.daffodil.lib.equality.package$TypeEqual$;
import org.apache.daffodil.lib.equality.package$TypeEquality$;
import org.apache.daffodil.lib.exceptions.Assert$;
import org.apache.daffodil.lib.util.MaybeULong$;
import org.apache.daffodil.runtime1.processors.CharsetEv;
import org.apache.daffodil.runtime1.processors.ChoiceRuntimeData;
import org.apache.daffodil.runtime1.processors.ElementRuntimeData;
import org.apache.daffodil.runtime1.processors.Evaluatable;
import org.apache.daffodil.runtime1.processors.Processor;
import org.apache.daffodil.runtime1.processors.ProcessorResult;
import org.apache.daffodil.runtime1.processors.RuntimeData;
import org.apache.daffodil.runtime1.processors.Success$;
import org.apache.daffodil.runtime1.processors.parsers.CaptureParsingValueLength;
import org.apache.daffodil.runtime1.processors.parsers.CombinatorParser;
import org.apache.daffodil.runtime1.processors.parsers.PState;
import org.apache.daffodil.runtime1.processors.parsers.Parser;
import passera.unsigned.ULong$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Vector;
import scala.package$;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;

public abstract class SpecifiedLengthParserBase
extends CombinatorParser
implements CaptureParsingValueLength {
    private final Parser eParser;
    private final RuntimeData erd;

    public SpecifiedLengthParserBase(Parser eParser, RuntimeData erd) {
        this.eParser = eParser;
        this.erd = erd;
        super(erd);
    }

    @Override
    public Vector<Evaluatable<Object>> runtimeDependencies() {
        return (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
    }

    @Override
    public Vector<Processor> childProcessors() {
        return (Vector)package$.MODULE$.Vector().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Parser[]{this.eParser}));
    }

    @Override
    public CharsetEv charsetEv() {
        throw Assert$.MODULE$.invariantFailed("Specified Length parsers should not capture value length using the charset");
    }

    public abstract long getBitLength(PState var1);

    @Override
    public final void parse(PState pState) {
        InputSourceDataInputStream IOUsingMacrosMixin_this;
        boolean shouldCheckDefinedForLength;
        ElementRuntimeData erd;
        long maybeNBits = this.getBitLength(pState);
        ProcessorResult processorResult = (ProcessorResult)org.apache.daffodil.lib.equality.package$.MODULE$.TypeEqual(pState.processorStatus());
        if (package$TypeEqual$.MODULE$._ne_$extension(processorResult, Success$.MODULE$, package$TypeEquality$.MODULE$.rightSubtypeOfLeftEquality())) {
            return;
        }
        long nBits = MaybeULong$.MODULE$.get$extension(maybeNBits);
        InputSourceDataInputStream dis = pState.dataInputStream();
        RuntimeData runtimeData = this.erd;
        boolean bl = runtimeData instanceof ElementRuntimeData ? !(erd = (ElementRuntimeData)runtimeData).isComplexType() : (shouldCheckDefinedForLength = !(runtimeData instanceof ChoiceRuntimeData));
        if (shouldCheckDefinedForLength && !dis.isDefinedForLength(nBits)) {
            this.PENotEnoughBits(pState, nBits, dis);
            return;
        }
        long startingBitPos0b = dis.bitPos0b();
        InputSourceDataInputStream dStream = IOUsingMacrosMixin_this = dis;
        long newLengthLimit = nBits;
        long savedLengthLimit = dStream.bitLimit0b();
        if (!dStream.setBitLimit0b(MaybeULong$.MODULE$.apply(dStream.bitPos0b() + newLengthLimit))) {
            v1 = false;
        } else {
            try {
                this.eParser.parse1(pState);
            }
            finally {
                dStream.resetBitLimit0b(savedLengthLimit);
            }
            v1 = true;
        }
        if (pState.processorStatus() != Success$.MODULE$) {
            return;
        }
        long finalEndPos0b = startingBitPos0b + nBits;
        if (pState.infoset().isComplex() && !(this.erd instanceof ChoiceRuntimeData)) {
            this.captureValueLength(pState, ULong$.MODULE$.apply(startingBitPos0b), ULong$.MODULE$.apply(dis.bitPos0b()));
        }
        if (dis != pState.dataInputStream()) {
            throw Assert$.MODULE$.abort("Invariant broken: dis.eq(pState.dataInputStream)");
        }
        long bitsToSkip = finalEndPos0b - dis.bitPos0b();
        if (bitsToSkip < 0L) {
            throw Assert$.MODULE$.abort("Invariant broken: bitsToSkip.>=(0)");
        }
        if (bitsToSkip > 0L) {
            boolean skipSuccess = dis.skip(bitsToSkip, pState);
            if (!skipSuccess) {
                this.PENotEnoughBits(pState, bitsToSkip, dis);
                return;
            }
            return;
        }
    }
}

