/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.management;

import org.apache.activemq.artemis.core.config.JMXConnectorConfiguration;
import org.apache.activemq.artemis.core.server.ServiceComponent;
import org.apache.activemq.artemis.core.server.management.ArtemisMBeanServerBuilder;
import org.apache.activemq.artemis.core.server.management.ArtemisMBeanServerGuard;
import org.apache.activemq.artemis.core.server.management.GuardInvocationHandler;
import org.apache.activemq.artemis.core.server.management.JMXAccessControlList;
import org.apache.activemq.artemis.core.server.management.ManagementConnector;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;

public class ManagementContext
implements ServiceComponent {
    private volatile boolean isStarted = false;
    private JMXAccessControlList accessControlList;
    private JMXConnectorConfiguration jmxConnectorConfiguration;
    private ManagementConnector mBeanServer;
    private GuardInvocationHandler guard;
    private ActiveMQSecurityManager securityManager;

    public void init() {
        if (this.accessControlList != null) {
            System.setProperty("javax.management.builder.initial", ArtemisMBeanServerBuilder.class.getCanonicalName());
            ArtemisMBeanServerGuard guardHandler = new ArtemisMBeanServerGuard();
            guardHandler.setJMXAccessControlList(this.accessControlList);
            ArtemisMBeanServerBuilder.setGuard(guardHandler);
            this.guard = guardHandler;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws Exception {
        if (this.isStarted) {
            return;
        }
        ManagementContext managementContext = this;
        synchronized (managementContext) {
            if (this.isStarted) {
                return;
            }
            this.isStarted = true;
            if (this.jmxConnectorConfiguration != null) {
                this.mBeanServer = new ManagementConnector(this.jmxConnectorConfiguration, this.securityManager);
                this.mBeanServer.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws Exception {
        if (!this.isStarted) {
            return;
        }
        ManagementContext managementContext = this;
        synchronized (managementContext) {
            if (!this.isStarted) {
                return;
            }
            this.isStarted = false;
            if (this.mBeanServer != null) {
                this.mBeanServer.stop();
            }
        }
    }

    public void stop(boolean shutdown) throws Exception {
        if (shutdown) {
            this.stop();
        }
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public void setAccessControlList(JMXAccessControlList accessControlList) {
        this.accessControlList = accessControlList;
    }

    public JMXAccessControlList getAccessControlList() {
        return this.accessControlList;
    }

    public void setJmxConnectorConfiguration(JMXConnectorConfiguration jmxConnectorConfiguration) {
        this.jmxConnectorConfiguration = jmxConnectorConfiguration;
    }

    public GuardInvocationHandler getArtemisMBeanServerGuard() {
        return this.guard;
    }

    public void setSecurityManager(ActiveMQSecurityManager securityManager) {
        this.securityManager = securityManager;
    }

    public ActiveMQSecurityManager getSecurityManager() {
        return this.securityManager;
    }

    public ManagementConnector getManagementConnector() {
        return this.mBeanServer;
    }
}

