/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.report.claim;

import java.util.List;
import org.apache.rat.api.Document;
import org.apache.rat.api.RatException;
import org.apache.rat.document.IDocumentAnalyser;
import org.apache.rat.document.RatDocumentAnalysisException;
import org.apache.rat.report.RatReport;
import org.apache.rat.report.xml.XmlElements;
import org.apache.rat.report.xml.writer.IXmlWriter;

public class ClaimReporterMultiplexer
implements RatReport {
    private final IDocumentAnalyser analyser;
    private final List<? extends RatReport> reporters;
    private final boolean dryRun;
    private final IXmlWriter writer;

    public ClaimReporterMultiplexer(IXmlWriter writer, boolean dryRun, IDocumentAnalyser analyser, List<? extends RatReport> reporters) {
        this.analyser = analyser;
        this.reporters = reporters;
        this.dryRun = dryRun;
        this.writer = writer;
    }

    @Override
    public void report(Document document) throws RatException {
        if (!this.dryRun) {
            if (this.analyser != null) {
                try {
                    this.analyser.analyse(document);
                }
                catch (RatDocumentAnalysisException e) {
                    throw new RatException(e.getMessage(), e);
                }
            }
            for (RatReport ratReport : this.reporters) {
                ratReport.report(document);
            }
        }
    }

    @Override
    public void startReport() throws RatException {
        new XmlElements(this.writer).ratReport();
        for (RatReport ratReport : this.reporters) {
            ratReport.startReport();
        }
    }

    @Override
    public void endReport() throws RatException {
        for (RatReport ratReport : this.reporters) {
            ratReport.endReport();
        }
        new XmlElements(this.writer).closeElement();
    }
}

