/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.config.exclusion.fileProcessors;

import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.rat.config.exclusion.fileProcessors.DescendingFileProcessor;
import org.apache.rat.document.DocumentName;

public final class HgIgnoreProcessor
extends DescendingFileProcessor {
    private static final Pattern SYNTAX_CHECK = Pattern.compile("^\\s?syntax:\\s+(glob|regexp)\\s?");
    private Syntax state = Syntax.REGEXP;

    public HgIgnoreProcessor() {
        super(".hgignore", "#");
    }

    @Override
    protected List<String> process(DocumentName baseName) {
        this.state = Syntax.REGEXP;
        return super.process(baseName);
    }

    @Override
    public String modifyEntry(DocumentName baseName, String entry) {
        Matcher m = SYNTAX_CHECK.matcher(entry.toLowerCase(Locale.ROOT));
        if (m.matches()) {
            this.state = Syntax.valueOf(m.group(1).toUpperCase());
            return null;
        }
        if (this.state == Syntax.REGEXP) {
            String pattern = entry.startsWith("^") ? entry.substring(1) : ".*" + entry;
            return String.format("%%regex[%s]", pattern);
        }
        return entry;
    }

    static enum Syntax {
        REGEXP,
        GLOB;

    }
}

