/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.utils;

import org.apache.rat.api.EnvVar;
import org.apache.rat.utils.Log;

public final class DefaultLog
implements Log {
    private static Log instance = new DefaultLog();
    private Log.Level level;

    public static Log getInstance() {
        return instance;
    }

    public static Log setInstance(Log newInstance) {
        Log result = instance;
        instance = newInstance == null ? new DefaultLog() : newInstance;
        return result;
    }

    public static Log createDefault() {
        return new DefaultLog();
    }

    private DefaultLog() {
        try {
            this.level = EnvVar.RAT_DEFAULT_LOG_LEVEL.isSet() ? Log.Level.valueOf(EnvVar.RAT_DEFAULT_LOG_LEVEL.getValue().toUpperCase()) : Log.Level.INFO;
        }
        catch (IllegalArgumentException e) {
            this.level = Log.Level.INFO;
            this.log(Log.Level.WARN, "Invalid log level set in environment: " + EnvVar.RAT_DEFAULT_LOG_LEVEL.getValue().toUpperCase(), (Throwable)e);
        }
    }

    @Override
    public void setLevel(Log.Level level) {
        this.level = level;
    }

    @Override
    public Log.Level getLevel() {
        return this.level;
    }

    @Override
    public void log(Log.Level level, String msg) {
        if (this.isEnabled(level)) {
            switch (level) {
                case DEBUG: 
                case INFO: 
                case WARN: {
                    System.out.format("%s: %s%n", new Object[]{level, msg});
                    break;
                }
                case ERROR: {
                    System.err.format("%s: %s%n", new Object[]{level, msg});
                    break;
                }
            }
        }
    }
}

