/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.io.input;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.time.Instant;
import org.apache.commons.io.ThreadUtils;
import org.apache.commons.io.input.MessageDigestInputStreamTest;
import org.apache.commons.io.input.ObservableInputStream;
import org.apache.commons.io.input.TimestampedObserver;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TimestampedObserverTest {
    TimestampedObserverTest() {
    }

    @Test
    void test() throws IOException, InterruptedException {
        Instant before = Instant.now();
        ThreadUtils.sleep((Duration)Duration.ofMillis(20L));
        TimestampedObserver timestampedObserver = new TimestampedObserver();
        Assertions.assertFalse((boolean)timestampedObserver.isClosed());
        ThreadUtils.sleep((Duration)Duration.ofMillis(20L));
        Assertions.assertNotNull((Object)timestampedObserver.toString());
        Assertions.assertTrue((boolean)timestampedObserver.getOpenInstant().isAfter(before));
        Assertions.assertTrue((timestampedObserver.getOpenToNowDuration().toNanos() > 0L ? 1 : 0) != 0);
        Assertions.assertNull((Object)timestampedObserver.getCloseInstant());
        Assertions.assertFalse((boolean)timestampedObserver.isClosed());
        byte[] buffer = MessageDigestInputStreamTest.generateRandomByteStream(8192);
        try (ObservableInputStream ois = new ObservableInputStream((InputStream)new ByteArrayInputStream(buffer), new ObservableInputStream.Observer[]{timestampedObserver});){
            Assertions.assertTrue((boolean)timestampedObserver.getOpenInstant().isAfter(before));
            Assertions.assertTrue((timestampedObserver.getOpenToNowDuration().toNanos() > 0L ? 1 : 0) != 0);
            Assertions.assertFalse((boolean)timestampedObserver.isClosed());
        }
        Assertions.assertTrue((boolean)timestampedObserver.isClosed());
        Assertions.assertTrue((boolean)timestampedObserver.getOpenInstant().isAfter(before));
        Assertions.assertTrue((timestampedObserver.getOpenToNowDuration().toNanos() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)timestampedObserver.getCloseInstant().isAfter(timestampedObserver.getOpenInstant()));
        Assertions.assertTrue((timestampedObserver.getOpenToCloseDuration().toNanos() > 0L ? 1 : 0) != 0);
        Assertions.assertNotNull((Object)timestampedObserver.toString());
    }

    @Test
    void testExample() throws IOException {
        TimestampedObserver timestampedObserver = new TimestampedObserver();
        byte[] buffer = MessageDigestInputStreamTest.generateRandomByteStream(8192);
        ObservableInputStream ois = new ObservableInputStream((InputStream)new ByteArrayInputStream(buffer), new ObservableInputStream.Observer[]{timestampedObserver});
        ois.close();
    }
}

