/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.configuration2;

import org.apache.commons.configuration2.BaseConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.ConfigurationComparator;
import org.apache.commons.configuration2.StrictConfigurationComparator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestStrictConfigurationComparator {
    protected ConfigurationComparator comparator = new StrictConfigurationComparator();
    protected Configuration configuration = new BaseConfiguration();

    @Test
    void testCompare() {
        Assertions.assertTrue((boolean)this.comparator.compare(this.configuration, this.configuration));
        this.configuration.setProperty("one", (Object)"1");
        this.configuration.setProperty("two", (Object)"2");
        this.configuration.setProperty("three", (Object)"3");
        Assertions.assertTrue((boolean)this.comparator.compare(this.configuration, this.configuration));
        BaseConfiguration other = new BaseConfiguration();
        Assertions.assertFalse((boolean)this.comparator.compare(this.configuration, (Configuration)other));
        other.setProperty("one", (Object)"1");
        other.setProperty("two", (Object)"2");
        other.setProperty("three", (Object)"3");
        Assertions.assertTrue((boolean)this.comparator.compare(this.configuration, (Configuration)other));
        other.setProperty("four", (Object)"4");
        Assertions.assertFalse((boolean)this.comparator.compare(this.configuration, (Configuration)other));
        this.configuration.setProperty("four", (Object)"4");
        Assertions.assertTrue((boolean)this.comparator.compare(this.configuration, (Configuration)other));
    }

    @Test
    void testCompareNull() {
        Assertions.assertTrue((boolean)this.comparator.compare(null, null));
        Assertions.assertFalse((boolean)this.comparator.compare(this.configuration, null));
        Assertions.assertFalse((boolean)this.comparator.compare(null, this.configuration));
    }
}

