/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;

public class Exit
extends Task {
    private String message;
    private String ifCondition;
    private String unlessCondition;

    public void setMessage(String value) {
        this.message = value;
    }

    public void setIf(String c) {
        this.ifCondition = c;
    }

    public void setUnless(String c) {
        this.unlessCondition = c;
    }

    public void execute() throws BuildException {
        if (this.testIfCondition() && this.testUnlessCondition()) {
            String text = null;
            if (this.message != null && this.message.length() > 0) {
                text = this.message;
            } else {
                if (this.getProject().getProperty(this.ifCondition) != null) {
                    text = "if=" + this.ifCondition;
                }
                if (this.unlessCondition != null && this.unlessCondition.length() > 0 && this.getProject().getProperty(this.unlessCondition) == null) {
                    text = text == null ? "" : text + " and ";
                    text = text + "unless=" + this.unlessCondition;
                } else if (text == null) {
                    text = "No message";
                }
            }
            throw new BuildException(text);
        }
    }

    public void addText(String msg) {
        if (this.message == null) {
            this.message = "";
        }
        this.message = this.message + this.getProject().replaceProperties(msg);
    }

    private boolean testIfCondition() {
        if (this.ifCondition == null || "".equals(this.ifCondition)) {
            return true;
        }
        return this.getProject().getProperty(this.ifCondition) != null;
    }

    private boolean testUnlessCondition() {
        if (this.unlessCondition == null || "".equals(this.unlessCondition)) {
            return true;
        }
        return this.getProject().getProperty(this.unlessCondition) == null;
    }
}

