/*
 * Decompiled with CFR 0.152.
 */
package org.apache.harmony.jndi.provider.rmi.registry;

import java.util.NoSuchElementException;
import javax.naming.Binding;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.harmony.jndi.provider.rmi.registry.RegistryContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BindingEnumeration
implements NamingEnumeration<Binding> {
    protected final String[] names;
    protected int index = 0;
    protected RegistryContext context;

    public BindingEnumeration(String[] names, RegistryContext context) {
        this.names = names;
        this.context = context.cloneContext();
    }

    @Override
    public boolean hasMore() {
        if (this.index < this.names.length) {
            return true;
        }
        this.close();
        return false;
    }

    @Override
    public boolean hasMoreElements() {
        return this.hasMore();
    }

    @Override
    public Binding next() throws NoSuchElementException, NamingException {
        if (!this.hasMore()) {
            throw new NoSuchElementException();
        }
        String name = this.names[this.index++];
        Binding binding = new Binding(name, this.context.lookup(name));
        binding.setNameInNamespace(name);
        return binding;
    }

    @Override
    public Binding nextElement() {
        try {
            return this.next();
        }
        catch (NamingException e) {
            throw (NoSuchElementException)new NoSuchElementException().initCause(e);
        }
    }

    @Override
    public void close() {
        this.index = this.names.length;
        this.context.close();
    }
}

