/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.compressors.pack200;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.compress.compressors.pack200.Pack200CompressorInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.NullOutputStream;
import org.junit.jupiter.api.Test;

class Compress687Test {
    private static final String FIXTURE = "org/apache/commons/compress/COMPRESS-687/test-issue.7z";
    private static final int BUFFER_SIZE = 16384;

    Compress687Test() {
    }

    @Test
    void testTransferTo() throws Exception {
        Pack200CompressorInputStream compressInputStream;
        try (InputStream inputStream = Compress687Test.class.getClassLoader().getResourceAsStream(FIXTURE);){
            compressInputStream = new Pack200CompressorInputStream(inputStream);
            try {
                this.transferTo((InputStream)compressInputStream, (OutputStream)NullOutputStream.INSTANCE);
            }
            finally {
                compressInputStream.close();
            }
        }
        inputStream = Compress687Test.class.getClassLoader().getResourceAsStream(FIXTURE);
        try {
            compressInputStream = new Pack200CompressorInputStream(inputStream);
            try {
                IOUtils.copy((InputStream)compressInputStream, (OutputStream)NullOutputStream.INSTANCE);
            }
            finally {
                compressInputStream.close();
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        if (Boolean.getBoolean("Compress687Test.sysout")) {
            System.out.println("Done.");
        }
    }

    private long transferTo(InputStream in, OutputStream out) throws IOException {
        int read;
        long transferred = 0L;
        byte[] buffer = new byte[16384];
        while ((read = in.read(buffer, 0, 16384)) >= 0) {
            out.write(buffer, 0, read);
            if (transferred >= Long.MAX_VALUE) continue;
            try {
                transferred = Math.addExact(transferred, (long)read);
            }
            catch (ArithmeticException ignore) {
                transferred = Long.MAX_VALUE;
            }
        }
        return transferred;
    }
}

