/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.sql;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;

public class TestResultSetMetaData
implements InvocationHandler {
    protected String[][] metadata = new String[][]{{"bigDecimalProperty", BigDecimal.class.getName()}, {"booleanProperty", Boolean.class.getName()}, {"byteProperty", Byte.class.getName()}, {"dateProperty", Date.class.getName()}, {"doubleProperty", Double.class.getName()}, {"floatProperty", Float.class.getName()}, {"intProperty", Integer.class.getName()}, {"longProperty", Long.class.getName()}, {"nullProperty", String.class.getName()}, {"shortProperty", Short.class.getName()}, {"stringProperty", String.class.getName()}, {"timeProperty", Time.class.getName()}, {"timestampProperty", Timestamp.class.getName()}};

    public static ResultSetMetaData createProxy() {
        return TestResultSetMetaData.createProxy(new TestResultSetMetaData());
    }

    public static ResultSetMetaData createProxy(InvocationHandler invocationHandler) {
        ClassLoader classLoader = ResultSetMetaData.class.getClassLoader();
        Class[] interfaces = new Class[]{ResultSetMetaData.class};
        return (ResultSetMetaData)Proxy.newProxyInstance(classLoader, interfaces, invocationHandler);
    }

    public String getCatalogName(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getColumnClassName(int columnIndex) throws SQLException {
        return this.metadata[columnIndex - 1][1];
    }

    public int getColumnCount() throws SQLException {
        return this.metadata.length;
    }

    public int getColumnDisplaySize(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getColumnLabel(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getColumnName(int columnIndex) throws SQLException {
        return this.metadata[columnIndex - 1][0];
    }

    public Integer getColumnType(int columnIndex) throws SQLException {
        String columnName = this.getColumnName(columnIndex);
        int sqlType = 1111;
        switch (columnName) {
            case "bigDecimalProperty": {
                sqlType = 3;
                break;
            }
            case "byteProperty": {
                sqlType = -6;
                break;
            }
            case "dateProperty": {
                sqlType = 91;
                break;
            }
            case "doubleProperty": {
                sqlType = 8;
                break;
            }
            case "floatProperty": {
                sqlType = 6;
                break;
            }
            case "intProperty": {
                sqlType = 4;
                break;
            }
            case "longProperty": {
                sqlType = -5;
                break;
            }
            case "nullProperty": {
                sqlType = 12;
                break;
            }
            case "shortProperty": {
                sqlType = 5;
                break;
            }
            case "stringProperty": {
                sqlType = 12;
                break;
            }
            case "timeProperty": {
                sqlType = 92;
                break;
            }
            case "timestampProperty": {
                sqlType = 93;
                break;
            }
            default: {
                sqlType = 1111;
            }
        }
        return sqlType;
    }

    public String getColumnTypeName(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getPrecision(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int getScale(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getSchemaName(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public String getTableName(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName;
        switch (methodName = method.getName()) {
            case "getColumnClassName": {
                return this.getColumnClassName((Integer)args[0]);
            }
            case "getColumnCount": {
                return this.getColumnCount();
            }
            case "getColumnName": {
                return this.getColumnName((Integer)args[0]);
            }
            case "getColumnType": {
                return this.getColumnType((Integer)args[0]);
            }
        }
        throw new UnsupportedOperationException(methodName + " not implemented");
    }

    public boolean isAutoIncrement(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isCaseSensitive(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isCurrency(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isDefinitelyWritable(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public int isNullable(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isReadOnly(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isSearchable(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isSigned(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }

    public boolean isWritable(int columnIndex) throws SQLException {
        throw new UnsupportedOperationException();
    }
}

