/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.beanutils2.converters;

import java.text.DateFormatSymbols;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.beanutils2.ConversionException;
import org.apache.commons.beanutils2.converters.AbstractLocaleConverterTest;
import org.apache.commons.beanutils2.locale.converters.DateLocaleConverter;
import org.apache.commons.lang3.SystemProperties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class DateLocaleConverterTest
extends AbstractLocaleConverterTest<Date> {
    private static final Log LOG = LogFactory.getLog(DateLocaleConverterTest.class);
    protected String localizedDatePattern;
    protected String localizedDateValue;
    protected String localizedShortDateValue;
    protected String defaultDatePattern;
    protected String defaultDateValue;
    protected String defaultShortDateValue;
    protected boolean validLocalDateSymbols;

    DateLocaleConverterTest() {
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        String version = SystemProperties.getJavaSpecificationVersion();
        LOG.debug((Object)("JDK Version " + version));
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyyMMdd");
            this.expectedValue = format.parse("20041001");
            this.defaultValue = format.parse("19670316");
        }
        catch (Exception ex) {
            LOG.error((Object)"Error creating expected/default dates", (Throwable)ex);
        }
        this.defaultLocale = Locale.US;
        this.defaultDatePattern = "d MMMM yyyy";
        this.defaultDateValue = "1 October 2004";
        this.defaultShortDateValue = "10/01/04";
        this.localizedLocale = new Locale("de", "AT");
        this.localizedDatePattern = "t MMMM uuuu";
        this.localizedDateValue = "1 Oktober 2004";
        this.localizedShortDateValue = "01.10.04";
        String expectedChars = "GuMtkHmsSEDFwWahKzZ";
        DateFormatSymbols localizedSymbols = new DateFormatSymbols(this.localizedLocale);
        String localChars = localizedSymbols.getLocalPatternChars();
        int lth = localChars.length() > "GuMtkHmsSEDFwWahKzZ".length() ? "GuMtkHmsSEDFwWahKzZ".length() : Math.min(localChars.length(), "GuMtkHmsSEDFwWahKzZ".length());
        this.validLocalDateSymbols = "GuMtkHmsSEDFwWahKzZ".substring(0, lth).equals(localChars.substring(0, lth));
    }

    @Test
    public void testCalendarObject() {
        this.converter = ((DateLocaleConverter.Builder)DateLocaleConverter.builder().setLocale(this.defaultLocale)).get();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime((Date)this.expectedValue);
        Assertions.assertEquals((Object)this.expectedValue, (Object)this.converter.convert((Object)calendar), (String)"java.util.Calendar");
    }

    @Test
    public void testConstructor_2() {
        this.converter = DateLocaleConverter.builder().get();
        this.convertValueNoPattern(this.converter, this.defaultShortDateValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.defaultDateValue, this.defaultDatePattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
        this.converter = DateLocaleConverter.builder().get();
        this.convertValueNoPattern(this.converter, this.defaultShortDateValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.defaultDateValue, this.defaultDatePattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    @Test
    public void testConstructor_3() {
        this.converter = ((DateLocaleConverter.Builder)DateLocaleConverter.builder().setLocalizedPattern(true)).get();
        this.convertValueNoPattern(this.converter, this.defaultShortDateValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.defaultDateValue, this.defaultDatePattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    @Test
    public void testConstructor_4() {
        this.converter = ((DateLocaleConverter.Builder)DateLocaleConverter.builder().setLocale(this.localizedLocale)).get();
        this.convertValueNoPattern(this.converter, this.localizedShortDateValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.localizedDateValue, this.defaultDatePattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    @Test
    public void testConstructor_5() {
        if (!this.validLocalDateSymbols) {
            LOG.error((Object)"Invalid locale symbols *** skipping testConstructor_5() **");
            return;
        }
        this.converter = ((DateLocaleConverter.Builder)((DateLocaleConverter.Builder)DateLocaleConverter.builder().setLocale(this.localizedLocale)).setLocalizedPattern(true)).get();
        this.convertValueNoPattern(this.converter, this.localizedShortDateValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.localizedDateValue, this.localizedDatePattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    @Test
    public void testConstructor_6() {
        this.converter = ((DateLocaleConverter.Builder)((DateLocaleConverter.Builder)DateLocaleConverter.builder().setLocale(this.localizedLocale)).setPattern(this.defaultDatePattern)).get();
        this.convertValueNoPattern(this.converter, this.localizedDateValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.localizedDateValue, this.defaultDatePattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    @Test
    public void testConstructor_7() {
        if (!this.validLocalDateSymbols) {
            LOG.error((Object)"Invalid locale symbols *** skipping testConstructor_7() **");
            return;
        }
        this.converter = ((DateLocaleConverter.Builder)((DateLocaleConverter.Builder)((DateLocaleConverter.Builder)DateLocaleConverter.builder().setLocale(this.localizedLocale)).setPattern(this.localizedDatePattern)).setLocalizedPattern(true)).get();
        this.convertValueNoPattern(this.converter, this.localizedDateValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.localizedDateValue, this.localizedDatePattern, this.expectedValue);
        this.convertInvalid(this.converter, null);
        this.convertNull(this.converter, null);
    }

    @Test
    public void testConstructor_8() {
        this.converter = ((DateLocaleConverter.Builder)DateLocaleConverter.builder().setDefault((Object)((Date)this.defaultValue))).get();
        this.convertValueNoPattern(this.converter, this.defaultShortDateValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.defaultDateValue, this.defaultDatePattern, this.expectedValue);
        this.convertInvalid(this.converter, this.defaultValue);
        this.convertNull(this.converter, this.defaultValue);
    }

    @Test
    public void testConstructor_9() {
        this.converter = ((DateLocaleConverter.Builder)((DateLocaleConverter.Builder)DateLocaleConverter.builder().setDefault((Object)((Date)this.defaultValue))).setLocalizedPattern(true)).get();
        this.converter = ((DateLocaleConverter.Builder)((DateLocaleConverter.Builder)DateLocaleConverter.builder().setDefault((Object)((Date)this.defaultValue))).setLocalizedPattern(true)).get();
        this.converter = ((DateLocaleConverter.Builder)((DateLocaleConverter.Builder)DateLocaleConverter.builder().setDefault((Object)((Date)this.defaultValue))).setLocalizedPattern(true)).get();
        this.convertValueNoPattern(this.converter, this.defaultShortDateValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, this.defaultDateValue, this.defaultDatePattern, this.expectedValue);
        this.convertInvalid(this.converter, this.defaultValue);
        this.convertNull(this.converter, this.defaultValue);
    }

    @Test
    public void testConstructorMain() {
        if (!this.validLocalDateSymbols) {
            LOG.error((Object)"Invalid locale symbols *** skipping testConstructorMain() **");
            return;
        }
        this.converter = ((DateLocaleConverter.Builder)((DateLocaleConverter.Builder)((DateLocaleConverter.Builder)((DateLocaleConverter.Builder)DateLocaleConverter.builder().setDefault((Object)((Date)this.defaultValue))).setLocale(this.localizedLocale)).setPattern(this.localizedDatePattern)).setLocalizedPattern(true)).get();
        this.convertValueNoPattern(this.converter, "(A)", this.localizedDateValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, "(A)", this.localizedDateValue, this.localizedDatePattern, this.expectedValue);
        this.convertInvalid(this.converter, "(A)", this.defaultValue);
        this.convertNull(this.converter, "(A)", this.defaultValue);
        this.convertValueNoPattern(this.converter, "(B)", this.defaultDateValue, this.defaultValue);
        this.convertValueWithPattern(this.converter, "(B)", this.localizedDateValue, this.defaultDatePattern, this.defaultValue);
        this.converter = ((DateLocaleConverter.Builder)((DateLocaleConverter.Builder)((DateLocaleConverter.Builder)((DateLocaleConverter.Builder)DateLocaleConverter.builder().setDefault((Object)((Date)this.defaultValue))).setLocale(this.localizedLocale)).setPattern(this.defaultDatePattern)).setLocalizedPattern(false)).get();
        this.convertValueNoPattern(this.converter, "(C)", this.localizedDateValue, this.expectedValue);
        this.convertValueWithPattern(this.converter, "(C)", this.localizedDateValue, this.defaultDatePattern, this.expectedValue);
        this.convertInvalid(this.converter, "(C)", this.defaultValue);
        this.convertNull(this.converter, "(C)", this.defaultValue);
    }

    @Test
    public void testDateObject() {
        this.converter = ((DateLocaleConverter.Builder)DateLocaleConverter.builder().setLocale(this.defaultLocale)).get();
        Assertions.assertEquals((Object)this.expectedValue, (Object)this.converter.convert(this.expectedValue), (String)"java.util.Date");
    }

    @Test
    public void testInvalidDate() {
        this.converter = ((DateLocaleConverter.Builder)DateLocaleConverter.builder().setLocale(this.defaultLocale)).get();
        try {
            this.converter.convert((Object)"01/10/2004", "dd-MM-yyyy");
        }
        catch (ConversionException e) {
            Assertions.assertEquals((Object)"Error parsing date '01/10/2004' at position = 2", (Object)e.getMessage(), (String)"Parse Error");
        }
        try {
            this.converter.convert((Object)"01-10-2004X", "dd-MM-yyyy");
        }
        catch (ConversionException e) {
            Assertions.assertEquals((Object)"Date '01-10-2004X' contains unparsed characters from position = 10", (Object)e.getMessage(), (String)"Parse Length");
        }
    }

    @Test
    public void testSetLenient() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("MMM dd, yyyy", Locale.UK);
        dateFormat.setLenient(false);
        try {
            dateFormat.parse("Feb 10, 2001");
        }
        catch (ParseException e) {
            Assertions.fail((String)("Could not parse date (1) - " + e.getMessage()));
        }
        try {
            dateFormat.parse("Feb 31, 2001");
            Assertions.fail((String)"Parsed illegal date (1)");
        }
        catch (ParseException e) {
            // empty catch block
        }
        dateFormat.setLenient(true);
        try {
            dateFormat.parse("Feb 10, 2001");
        }
        catch (ParseException e) {
            Assertions.fail((String)("Could not parse date (2) - " + e.getMessage()));
        }
        try {
            dateFormat.parse("Feb 31, 2001");
        }
        catch (ParseException e) {
            Assertions.fail((String)("Could not parse date (3) - " + e.getMessage()));
        }
        DateLocaleConverter.Builder builder = (DateLocaleConverter.Builder)((DateLocaleConverter.Builder)DateLocaleConverter.builder().setLocale(Locale.UK)).setLenient(false).setPattern("MMM dd, yyyy");
        DateLocaleConverter converter = builder.get();
        Assertions.assertEquals((Object)converter.isLenient(), (Object)false, (String)"Set lenient failed");
        try {
            converter.convert((Object)"Feb 10, 2001");
        }
        catch (ConversionException e) {
            Assertions.fail((String)("Could not parse date (4) - " + e.getMessage()));
        }
        try {
            converter.convert((Object)"Feb 31, 2001");
            Assertions.assertEquals((Object)converter.isLenient(), (Object)false, (String)"Set lenient failed");
            Assertions.fail((String)"Parsed illegal date (2)");
        }
        catch (ConversionException e) {
            // empty catch block
        }
        converter = builder.setLenient(true).get();
        Assertions.assertEquals((Object)converter.isLenient(), (Object)true, (String)"Set lenient failed");
        try {
            converter.convert((Object)"Feb 10, 2001");
        }
        catch (ConversionException e) {
            Assertions.fail((String)("Could not parse date (5) - " + e.getMessage()));
        }
        try {
            converter.convert((Object)"Feb 31, 2001");
        }
        catch (ConversionException e) {
            Assertions.fail((String)("Could not parse date (6) - " + e.getMessage()));
        }
    }
}

