/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.client;

import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.cassandra.sidecar.client.HttpClient;
import org.apache.cassandra.sidecar.client.HttpResponse;
import org.apache.cassandra.sidecar.client.RequestContext;
import org.apache.cassandra.sidecar.client.SidecarInstance;
import org.apache.cassandra.sidecar.client.StreamConsumer;
import org.apache.cassandra.sidecar.common.request.Request;
import org.apache.cassandra.sidecar.common.request.ResponseBytesDecoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestExecutor
implements AutoCloseable {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final HttpClient httpClient;
    protected final ScheduledExecutorService singleThreadExecutorService;

    protected RequestExecutor(HttpClient httpClient) {
        this.httpClient = Objects.requireNonNull(httpClient, "The httpClient is required");
        this.singleThreadExecutorService = Executors.newSingleThreadScheduledExecutor();
    }

    public <T> T executeRequest(RequestContext context) throws ExecutionException, InterruptedException, TimeoutException {
        return this.executeRequest(context, this.httpClient.config().timeoutMillis(), TimeUnit.MILLISECONDS);
    }

    public <T> T executeRequest(RequestContext context, long timeout, TimeUnit unit) throws ExecutionException, InterruptedException, TimeoutException {
        return this.executeRequestAsync(context).get(timeout, unit);
    }

    public <T> CompletableFuture<T> executeRequestAsync(RequestContext context) {
        Iterator<SidecarInstance> iterator = context.instanceSelectionPolicy().iterator();
        CompletableFuture resultFuture = new CompletableFuture();
        if (!iterator.hasNext()) {
            resultFuture.completeExceptionally(new IllegalStateException("InstanceSelectionPolicy " + context.instanceSelectionPolicy().getClass().getSimpleName() + " selects 0 instances"));
            return resultFuture;
        }
        SidecarInstance instance = (SidecarInstance)iterator.next();
        CompletableFuture<HttpResponse> responseFuture = new CompletableFuture<HttpResponse>();
        this.executeWithRetries(responseFuture, iterator, instance, context, 1);
        responseFuture.whenComplete((response, retryThrowable) -> this.processResponse(resultFuture, context.request(), (HttpResponse)response, (Throwable)retryThrowable));
        return resultFuture;
    }

    public void streamRequest(RequestContext context, StreamConsumer streamConsumer) {
        Objects.requireNonNull(streamConsumer, "streamConsumer must be non-null");
        Iterator<SidecarInstance> iterator = context.instanceSelectionPolicy().iterator();
        if (!iterator.hasNext()) {
            streamConsumer.onError(new IllegalStateException("InstanceSelectionPolicy " + context.instanceSelectionPolicy().getClass().getSimpleName() + " selects 0 instances"));
            return;
        }
        SidecarInstance instance = (SidecarInstance)iterator.next();
        CompletableFuture<HttpResponse> responseFuture = new CompletableFuture<HttpResponse>();
        this.streamWithRetries(responseFuture, streamConsumer, iterator, instance, context, 1);
        responseFuture.whenComplete((response, throwable) -> {
            if (throwable != null) {
                streamConsumer.onError((Throwable)throwable);
            }
        });
    }

    @Override
    public void close() throws Exception {
        this.httpClient.close();
    }

    protected void executeWithRetries(CompletableFuture<HttpResponse> future, Iterator<SidecarInstance> iterator, SidecarInstance sidecarInstance, RequestContext context, int attempt) {
        this.logger.debug("Request from instance={}, request={}, attempt={}", new Object[]{sidecarInstance, context.request(), attempt});
        try {
            this.httpClient.execute(sidecarInstance, context).whenComplete((response, throwable) -> this.applyRetryPolicy(future, iterator, sidecarInstance, context, attempt, (HttpResponse)response, (Throwable)throwable));
        }
        catch (Throwable throwable2) {
            this.logger.error("Unexpected error while executing the request. instance={}, request={}, attempt={}", new Object[]{sidecarInstance, context.request(), attempt});
            future.completeExceptionally(throwable2);
        }
    }

    private void streamWithRetries(CompletableFuture<HttpResponse> future, StreamConsumer streamConsumer, Iterator<SidecarInstance> iterator, SidecarInstance sidecarInstance, RequestContext context, int attempt) {
        this.logger.debug("Streaming from instance={}, request={}, attempt={}", new Object[]{sidecarInstance, context.request(), attempt});
        try {
            this.httpClient.stream(sidecarInstance, context, streamConsumer).whenComplete((response, throwable) -> this.applyRetryPolicy(future, streamConsumer, iterator, sidecarInstance, context, attempt, (HttpResponse)response, (Throwable)throwable));
        }
        catch (Throwable throwable2) {
            this.logger.error("Unexpected error while streaming. instance={}, request={}, attempt={}", new Object[]{sidecarInstance, context.request(), attempt});
            future.completeExceptionally(throwable2);
        }
    }

    private void applyRetryPolicy(CompletableFuture<HttpResponse> future, Iterator<SidecarInstance> iterator, SidecarInstance sidecarInstance, RequestContext context, int attempt, HttpResponse response, Throwable throwable) {
        boolean retryOnNewHost = iterator.hasNext();
        Request request = context.request();
        context.retryPolicy().onResponse(future, request, response, throwable, attempt, retryOnNewHost, (nextAttempt, delay) -> {
            SidecarInstance nextInstance;
            String statusCode = response != null ? String.valueOf(response.statusCode()) : "<Not Available>";
            SidecarInstance sidecarInstance2 = nextInstance = iterator.hasNext() ? (SidecarInstance)iterator.next() : sidecarInstance;
            if (response == null || response.statusCode() != HttpResponseStatus.ACCEPTED.code()) {
                this.logger.warn("Retrying request on {} instance after {}ms. Failed on instance={}, attempt={}, statusCode={}", new Object[]{nextInstance == sidecarInstance ? "same" : "next", delay, sidecarInstance, attempt, statusCode, throwable});
            }
            this.schedule(delay, () -> this.executeWithRetries(future, iterator, nextInstance, context, nextAttempt));
        });
    }

    private void applyRetryPolicy(CompletableFuture<HttpResponse> future, StreamConsumer consumer, Iterator<SidecarInstance> iterator, SidecarInstance sidecarInstance, RequestContext context, int attempt, HttpResponse response, Throwable throwable) {
        boolean retryOnNewHost = iterator.hasNext();
        Request request = context.request();
        context.retryPolicy().onResponse(future, request, response, throwable, attempt, retryOnNewHost, (nextAttempt, delay) -> {
            SidecarInstance nextInstance;
            String statusCode = response != null ? String.valueOf(response.statusCode()) : "<Not Available>";
            SidecarInstance sidecarInstance2 = nextInstance = iterator.hasNext() ? (SidecarInstance)iterator.next() : sidecarInstance;
            if (response == null || response.statusCode() != HttpResponseStatus.ACCEPTED.code()) {
                this.logger.warn("Retrying stream on {} instance after {}ms. Failed on instance={}, attempt={}, statusCode={}", new Object[]{nextInstance == sidecarInstance ? "same" : "next", delay, sidecarInstance, attempt, statusCode, throwable});
            }
            this.schedule(delay, () -> this.streamWithRetries(future, consumer, iterator, nextInstance, context, nextAttempt));
        });
    }

    private <T> void processResponse(CompletableFuture<T> future, Request request, HttpResponse response, Throwable throwable) {
        if (throwable != null) {
            this.logger.error("Failed to process request={}, response={}", new Object[]{request, response, throwable});
            future.completeExceptionally(throwable);
            return;
        }
        try {
            ResponseBytesDecoder responseDecoder = request.responseBytesDecoder();
            if (responseDecoder != null) {
                future.complete(responseDecoder.decode(response.raw()));
            } else {
                future.complete(response.contentAsString());
            }
        }
        catch (Throwable t) {
            future.completeExceptionally(t);
        }
    }

    protected void schedule(long delayMillis, Runnable runnable) {
        if (delayMillis > 0L) {
            this.singleThreadExecutorService.schedule(runnable, delayMillis, TimeUnit.MILLISECONDS);
        }
        runnable.run();
    }
}

