/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.common.server.utils;

import java.util.concurrent.Callable;
import java.util.function.Predicate;
import org.apache.cassandra.sidecar.common.server.ThrowingRunnable;
import org.jetbrains.annotations.NotNull;

public final class ThrowableUtils {
    private ThrowableUtils() {
        throw new UnsupportedOperationException(this.getClass() + " is static utility class and shall not be instantiated");
    }

    @NotNull
    public static <T> java.util.function.Supplier<T> supplier(@NotNull Supplier<T> supplier) {
        return () -> {
            try {
                return supplier.get();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @NotNull
    public static <T> java.util.function.Consumer<T> consumer(@NotNull Consumer<T> consumer) {
        return object -> {
            try {
                consumer.accept(object);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    @NotNull
    public static <T, R> java.util.function.Function<T, R> function(@NotNull Function<T, R> function) {
        return object -> {
            try {
                return function.apply(object);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        };
    }

    public static <R> R propagate(Callable<R> actionMayThrow) {
        try {
            return actionMayThrow.call();
        }
        catch (Exception cause) {
            throw new RuntimeException(cause);
        }
    }

    public static void propagate(ThrowingRunnable actionMayThrow) {
        ThrowableUtils.propagate(() -> {
            actionMayThrow.run();
            return null;
        });
    }

    public static <T extends Throwable> T getCause(Throwable throwable, Class<T> expectedCauseKlass) {
        return (T)((Throwable)expectedCauseKlass.cast(ThrowableUtils.getCause(throwable, expectedCauseKlass::isInstance)));
    }

    public static Throwable getCause(Throwable throwable, Predicate<Throwable> predicate) {
        if (throwable == null) {
            return null;
        }
        Throwable cause = throwable;
        Throwable fastTracer = ThrowableUtils.getCause(cause, 1);
        Throwable stop = null;
        while (cause != null && stop != cause) {
            if (predicate.test(cause)) {
                return cause;
            }
            if (stop == null) {
                if (cause == fastTracer) {
                    stop = cause;
                } else {
                    fastTracer = ThrowableUtils.getCause(fastTracer, 2);
                }
            }
            cause = ThrowableUtils.getCause(cause, 1);
        }
        return null;
    }

    private static Throwable getCause(Throwable throwable, int depth) {
        Throwable t;
        for (t = throwable; depth-- > 0 && t != null; t = t.getCause()) {
        }
        return t;
    }

    @FunctionalInterface
    public static interface Function<T, R> {
        public R apply(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface Consumer<T> {
        public void accept(T var1) throws Exception;
    }

    @FunctionalInterface
    public static interface Supplier<T> {
        public T get() throws Exception;
    }
}

