/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.common.server.cluster.locator;

import java.math.BigInteger;
import org.apache.cassandra.sidecar.common.server.cluster.locator.Partitioner;
import org.apache.cassandra.sidecar.common.server.cluster.locator.Token;

public class Partitioners {
    private static final String FULL_PACKAGE_NAME = "org.apache.cassandra.dht.";
    private static final String RANDOM_PARTITIONER_NAME = RandomPartitioner.class.getSimpleName().toLowerCase();
    private static final String MURMUR3_PARTITIONER_NAME = Murmur3Partitioner.class.getSimpleName().toLowerCase();
    public static final Partitioner RANDOM = RandomPartitioner.INSTANCE;
    public static final Partitioner MURMUR3 = Murmur3Partitioner.INSTANCE;

    private Partitioners() {
        throw new UnsupportedOperationException();
    }

    public static Partitioner from(String className) {
        String simpleClassName = className.toLowerCase();
        if (simpleClassName.startsWith(FULL_PACKAGE_NAME)) {
            simpleClassName = simpleClassName.substring(FULL_PACKAGE_NAME.length());
        }
        if (simpleClassName.equals(RANDOM_PARTITIONER_NAME)) {
            return RandomPartitioner.INSTANCE;
        }
        if (simpleClassName.equals(MURMUR3_PARTITIONER_NAME)) {
            return Murmur3Partitioner.INSTANCE;
        }
        throw new IllegalArgumentException("Unsupported partitioner: " + simpleClassName);
    }

    private static class Murmur3Partitioner
    implements Partitioner {
        private static final Murmur3Partitioner INSTANCE = new Murmur3Partitioner();
        private static final Token MIN = Token.from(BigInteger.valueOf(Long.MIN_VALUE));
        private static final Token MAX = Token.from(BigInteger.valueOf(Long.MAX_VALUE));

        private Murmur3Partitioner() {
        }

        @Override
        public Token minimumToken() {
            return MIN;
        }

        @Override
        public Token maximumToken() {
            return MAX;
        }
    }

    private static class RandomPartitioner
    implements Partitioner {
        private static final RandomPartitioner INSTANCE = new RandomPartitioner();
        private static final Token MIN = Token.from(BigInteger.valueOf(-1L));
        private static final Token MAX = Token.from(BigInteger.valueOf(2L).pow(127));

        private RandomPartitioner() {
        }

        @Override
        public Token minimumToken() {
            return MIN;
        }

        @Override
        public Token maximumToken() {
            return MAX;
        }
    }
}

