/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.utils;

import java.io.File;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

public class FileUtils {
    private static final Pattern STORAGE_UNIT_PATTERN = Pattern.compile("(\\d+)(GiB|MiB|KiB|B)?");

    public static String maybeResolveHomeDirectory(String directory) {
        if (directory == null || !directory.startsWith("~")) {
            return directory;
        }
        return System.getProperty("user.home") + directory.substring(1);
    }

    public static long directorySizeBytes(File directory) {
        long size = 0L;
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isFile()) continue;
                size += file.length();
            }
        }
        return size;
    }

    public static long mbStringToBytes(String str) {
        return Long.parseLong(str) * 0x100000L;
    }

    @Nullable
    public static Long storageStringToBytes(String str) {
        Matcher matcher = STORAGE_UNIT_PATTERN.matcher(str);
        if (matcher.find()) {
            return Long.parseLong(matcher.group(1)) * FileUtils.storageUnitToBytes(matcher.group(2));
        }
        return null;
    }

    public static long storageUnitToBytes(String unit) {
        if (unit == null) {
            return 1L;
        }
        switch (unit) {
            case "GiB": {
                return 0x40000000L;
            }
            case "MiB": {
                return 0x100000L;
            }
            case "KiB": {
                return 1024L;
            }
            case "": 
            case "B": {
                return 1L;
            }
        }
        throw new IllegalStateException("Unexpected data storage unit: " + unit);
    }
}

