/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.utils;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.file.FileSystem;
import org.apache.cassandra.sidecar.utils.DigestAlgorithmProvider;
import org.apache.cassandra.sidecar.utils.DigestVerifier;
import org.apache.cassandra.sidecar.utils.MD5DigestVerifier;
import org.apache.cassandra.sidecar.utils.XXHash32DigestVerifier;
import org.jetbrains.annotations.VisibleForTesting;

@Singleton
public class DigestVerifierFactory {
    @VisibleForTesting
    static final DigestVerifier FALLBACK_VERIFIER = Future::succeededFuture;
    private final FileSystem fs;
    private final DigestAlgorithmProvider xxhash32;
    private final DigestAlgorithmProvider md5;

    @Inject
    public DigestVerifierFactory(Vertx vertx, @Named(value="xxhash32") DigestAlgorithmProvider xxhash32, @Named(value="md5") DigestAlgorithmProvider md5) {
        this.fs = vertx.fileSystem();
        this.xxhash32 = xxhash32;
        this.md5 = md5;
    }

    public DigestVerifier verifier(MultiMap headers) {
        if (headers.contains("cassandra-content-xxhash32")) {
            return XXHash32DigestVerifier.create(this.fs, headers, this.xxhash32);
        }
        if (headers.contains(HttpHeaderNames.CONTENT_MD5.toString())) {
            return MD5DigestVerifier.create(this.fs, headers, this.md5);
        }
        return FALLBACK_VERIFIER;
    }
}

