/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.routes;

import com.datastax.driver.core.KeyspaceMetadata;
import com.datastax.driver.core.TableMetadata;
import io.vertx.core.Future;
import io.vertx.ext.web.RoutingContext;
import java.util.Objects;
import java.util.Optional;
import org.apache.cassandra.sidecar.common.server.data.QualifiedTableName;
import org.apache.cassandra.sidecar.db.RestoreJob;

public class RoutingContextUtils {
    public static final TypedKey<KeyspaceMetadata> SC_KEYSPACE_METADATA = new TypedKey<KeyspaceMetadata>(KeyspaceMetadata.class, "SC_KEYSPACE_METADATA");
    public static final TypedKey<TableMetadata> SC_TABLE_METADATA = new TypedKey<TableMetadata>(TableMetadata.class, "SC_TABLE_METADATA");
    public static final TypedKey<RestoreJob> SC_RESTORE_JOB = new TypedKey<RestoreJob>(RestoreJob.class, "SC_RESTORE_JOB");
    public static final TypedKey<QualifiedTableName> SC_QUALIFIED_TABLE_NAME = new TypedKey<QualifiedTableName>(QualifiedTableName.class, "SC_QUALIFIED_TABLE_NAME");

    private RoutingContextUtils() {
    }

    public static <T> void put(RoutingContext context, TypedKey<T> typedKey, T value) {
        context.put(typedKey.key, value);
    }

    public static <T> T get(RoutingContext context, TypedKey<T> typedKey) throws RoutingContextException {
        Object obj = context.get(typedKey.key);
        if (obj == null) {
            throw new RoutingContextException("No value found for key " + typedKey);
        }
        if (!Objects.equals(obj.getClass(), typedKey.type)) {
            throw new RoutingContextException("The class of the stored value does not match with key " + typedKey);
        }
        return typedKey.type.cast(obj);
    }

    public static <T> Optional<T> getAsOptional(RoutingContext context, TypedKey<T> typedKey) {
        try {
            return Optional.of(RoutingContextUtils.get(context, typedKey));
        }
        catch (RoutingContextException e) {
            return Optional.empty();
        }
    }

    public static <T> Future<T> getAsFuture(RoutingContext context, TypedKey<T> typedKey) {
        return Future.future(promise -> {
            try {
                promise.complete(RoutingContextUtils.get(context, typedKey));
            }
            catch (RoutingContextException e) {
                promise.fail((Throwable)e);
            }
        });
    }

    public static class RoutingContextException
    extends Exception {
        public RoutingContextException(String msg) {
            super(msg);
        }

        public RoutingContextException(String msg, Throwable cause) {
            super(msg, cause);
        }
    }

    public static class TypedKey<T> {
        private final Class<T> type;
        private final String key;

        private TypedKey(Class<T> type, String key) {
            this.type = type;
            this.key = key;
        }

        public String toString() {
            return "TypedKey{type=" + this.type.getCanonicalName() + ", key=" + this.key + "}";
        }
    }
}

