/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.livemigration;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.List;
import org.apache.cassandra.sidecar.common.response.InstanceFileInfo;
import org.apache.cassandra.sidecar.livemigration.MigrationFileVisitor;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirVisitor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DirVisitor.class);
    private final String homeDir;
    private final Path homeDirPath;
    private final String pathPrefix;
    private final MigrationFileVisitor fileVisitor;

    public DirVisitor(String homeDir, String pathPrefix, List<PathMatcher> fileExclusionMatchers, List<PathMatcher> dirExclusionMatchers) {
        this.homeDir = homeDir;
        this.homeDirPath = Paths.get(homeDir, new String[0]);
        this.pathPrefix = pathPrefix;
        this.fileVisitor = new MigrationFileVisitor(homeDir, fileExclusionMatchers, dirExclusionMatchers);
    }

    public List<InstanceFileInfo> files() throws IOException {
        Files.walkFileTree(this.homeDirPath, this.fileVisitor);
        List<Path> validFiles = this.fileVisitor.validFilePaths();
        ArrayList<InstanceFileInfo> infos = new ArrayList<InstanceFileInfo>();
        for (Path path : validFiles) {
            infos.add(this.toInstanceFileInfo(path));
        }
        LOGGER.debug("Found {} instance files for homeDir {}", (Object)infos.size(), (Object)this.homeDir);
        return infos;
    }

    private InstanceFileInfo toInstanceFileInfo(@NotNull Path path) throws IOException {
        BasicFileAttributes attrs = Files.readAttributes(path, BasicFileAttributes.class, new LinkOption[0]);
        long lastModifiedTime = attrs.lastModifiedTime().toMillis();
        String fileUrl = this.buildInstanceFileUrl(path);
        boolean isDirectory = attrs.isDirectory();
        InstanceFileInfo.FileType fileType = isDirectory ? InstanceFileInfo.FileType.DIRECTORY : InstanceFileInfo.FileType.FILE;
        long size = isDirectory ? -1L : attrs.size();
        return new InstanceFileInfo(fileUrl, size, fileType, lastModifiedTime);
    }

    private String buildInstanceFileUrl(@NotNull Path path) {
        String relativePath = this.homeDirPath.relativize(path).toString();
        return this.pathPrefix + "/" + relativePath;
    }
}

