/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.db;

import com.datastax.driver.core.LocalDate;
import com.datastax.driver.core.Row;
import com.datastax.driver.core.utils.Bytes;
import com.datastax.driver.core.utils.UUIDs;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.UUID;
import org.apache.cassandra.sidecar.common.DataObjectBuilder;
import org.apache.cassandra.sidecar.common.data.ConsistencyConfig;
import org.apache.cassandra.sidecar.common.data.ConsistencyLevel;
import org.apache.cassandra.sidecar.common.data.RestoreJobSecrets;
import org.apache.cassandra.sidecar.common.data.RestoreJobStatus;
import org.apache.cassandra.sidecar.common.data.SSTableImportOptions;
import org.apache.cassandra.sidecar.common.server.data.RestoreRangeStatus;
import org.apache.cassandra.sidecar.common.utils.Preconditions;
import org.apache.cassandra.sidecar.common.utils.StringUtils;
import org.apache.cassandra.sidecar.db.DataObjectMappingException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestoreJob {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestoreJob.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();
    public final LocalDate createdAt;
    public final UUID jobId;
    public final String keyspaceName;
    public final String tableName;
    public final String jobAgent;
    public final RestoreJobStatus status;
    public final RestoreJobSecrets secrets;
    public final SSTableImportOptions importOptions;
    public final Date expireAt;
    public final short bucketCount;
    @Nullable
    public final ConsistencyLevel consistencyLevel;
    @Nullable
    public final String localDatacenter;
    public final boolean shouldRestoreToLocalDatacenterOnly;
    public final Manager restoreJobManager;
    public final Long sliceCount;
    private final String statusText;

    public static Builder builder() {
        return new Builder();
    }

    public static RestoreJob from(@NotNull Row row) throws DataObjectMappingException {
        Builder builder = new Builder();
        ConsistencyConfig consistencyConfig = ConsistencyConfig.parseString((String)row.getString("consistency_level"), (String)row.getString("local_datacenter"));
        builder.createdAt(row.getDate("created_at")).jobId(row.getUUID("job_id")).jobAgent(row.getString("job_agent")).bucketCount((short)0).keyspace(row.getString("keyspace_name")).table(row.getString("table_name")).jobStatusText(row.getString("status")).jobSecrets(RestoreJob.decodeJobSecrets(row.getBytes("blob_secrets"))).expireAt(row.getTimestamp("expire_at")).sstableImportOptions(RestoreJob.decodeSSTableImportOptions(row.getBytes("import_options"))).consistencyLevel(consistencyConfig.consistencyLevel).localDatacenter(consistencyConfig.localDatacenter).shouldRestoreToLocalDatacenterOnly(row.getBool("local_datacenter_only")).sliceCount((Long)row.get("slice_count", Long.class));
        return builder.build();
    }

    private static RestoreJobStatus decodeJobStatus(String status) {
        if (status == null) {
            return null;
        }
        String enumLiteral = status.split(":")[0];
        return RestoreJobStatus.valueOf((String)enumLiteral.toUpperCase());
    }

    private static RestoreJobSecrets decodeJobSecrets(ByteBuffer secretsBytes) {
        return secretsBytes == null ? null : RestoreJob.deserializeJsonBytes(secretsBytes, RestoreJobSecrets.class, "secrets");
    }

    private static SSTableImportOptions decodeSSTableImportOptions(ByteBuffer importOptionsBytes) {
        return importOptionsBytes == null ? null : RestoreJob.deserializeJsonBytes(importOptionsBytes, SSTableImportOptions.class, "importOptions");
    }

    private RestoreJob(Builder builder) {
        Preconditions.checkArgument((builder.consistencyLevel == null || !builder.consistencyLevel.isLocalDcOnly || StringUtils.isNotEmpty((String)builder.localDatacenter) ? 1 : 0) != 0, (String)"When local consistency level is used, localDatacenter must also present");
        boolean hasEffectiveLocalDC = StringUtils.isNotEmpty((String)builder.localDatacenter);
        if ((builder.consistencyLevel == null || !builder.consistencyLevel.isLocalDcOnly) && hasEffectiveLocalDC) {
            LOGGER.warn("'localDatacenter' is defined but ignored. consistencyLevel={} localDatacenter={}", (Object)builder.consistencyLevel, (Object)builder.localDatacenter);
            hasEffectiveLocalDC = false;
        }
        if (builder.shouldRestoreToLocalDatacenterOnly && !hasEffectiveLocalDC) {
            this.shouldRestoreToLocalDatacenterOnly = false;
            LOGGER.warn("shouldRestoreToLocalDatacenterOnly is true but 'localDatacenter' is not defined or invalid. Resetting shouldRestoreToLocalDatacenterOnly to false");
        } else {
            this.shouldRestoreToLocalDatacenterOnly = builder.shouldRestoreToLocalDatacenterOnly;
        }
        this.createdAt = builder.createdAt;
        this.jobId = builder.jobId;
        this.keyspaceName = builder.keyspaceName;
        this.tableName = builder.tableName;
        this.jobAgent = builder.jobAgent;
        this.status = builder.status;
        this.statusText = builder.statusText;
        this.secrets = builder.secrets;
        this.importOptions = builder.importOptions == null ? SSTableImportOptions.defaults() : builder.importOptions;
        this.expireAt = builder.expireAt;
        this.bucketCount = builder.bucketCount;
        this.consistencyLevel = builder.consistencyLevel;
        this.localDatacenter = builder.localDatacenter;
        this.restoreJobManager = builder.manager;
        this.sliceCount = builder.sliceCount;
    }

    public Builder unbuild() {
        return new Builder(this);
    }

    public boolean isManagedBySidecar() {
        return this.restoreJobManager == Manager.SIDECAR;
    }

    public String statusWithOptionalDescription() {
        return this.statusText;
    }

    public boolean hasExpired(long referenceTimestampMillis) {
        return this.expireAt != null && referenceTimestampMillis >= this.expireAt.getTime();
    }

    public RestoreRangeStatus expectedNextRangeStatus() {
        Preconditions.checkArgument((this.status != RestoreJobStatus.CREATED ? 1 : 0) != 0, (String)("Cannot check progress for restore job in CREATED status. jobId: " + this.jobId));
        return this.status == RestoreJobStatus.STAGE_READY || this.status == RestoreJobStatus.STAGED ? RestoreRangeStatus.STAGED : RestoreRangeStatus.SUCCEEDED;
    }

    @Nullable
    public String consistencyLevelText() {
        return this.consistencyLevel == null ? null : this.consistencyLevel.name();
    }

    public String toString() {
        return String.format("RestoreJob{createdAt='%s', jobId='%s', keyspaceName='%s', tableName='%s', status='%s', secrets='%s', importOptions='%s', expireAt='%s', bucketCount='%s', consistencyLevel='%s', localDatacenter='%s', shouldRestoreToLocalDatacenterOnly='%s'}", this.createdAt.toString(), this.jobId.toString(), this.keyspaceName, this.tableName, this.statusText, this.secrets, this.importOptions, this.expireAt, this.bucketCount, this.consistencyLevel, this.localDatacenter, this.shouldRestoreToLocalDatacenterOnly);
    }

    public static LocalDate toLocalDate(UUID jobId) {
        return LocalDate.fromMillisSinceEpoch((long)UUIDs.unixTimestamp((UUID)jobId));
    }

    private static <T> T deserializeJsonBytes(ByteBuffer byteBuffer, Class<T> type, String fieldNameHint) {
        try {
            return (T)MAPPER.readValue(Bytes.getArray((ByteBuffer)byteBuffer), type);
        }
        catch (IOException e) {
            throw new DataObjectMappingException("Failed to deserialize " + fieldNameHint, (Throwable)e);
        }
    }

    public static enum Manager {
        SPARK,
        SIDECAR;

    }

    public static class Builder
    implements DataObjectBuilder<Builder, RestoreJob> {
        private LocalDate createdAt;
        private UUID jobId;
        private String keyspaceName;
        private String tableName;
        private String jobAgent;
        private RestoreJobStatus status;
        private String statusText;
        private RestoreJobSecrets secrets;
        private SSTableImportOptions importOptions;
        private Date expireAt;
        private short bucketCount;
        private ConsistencyLevel consistencyLevel;
        private String localDatacenter;
        private boolean shouldRestoreToLocalDatacenterOnly = false;
        private Manager manager;
        private Long sliceCount;

        private Builder() {
        }

        private Builder(RestoreJob restoreJob) {
            this.createdAt = restoreJob.createdAt;
            this.jobId = restoreJob.jobId;
            this.keyspaceName = restoreJob.keyspaceName;
            this.tableName = restoreJob.tableName;
            this.jobAgent = restoreJob.jobAgent;
            this.status = restoreJob.status;
            this.statusText = restoreJob.statusText;
            this.secrets = restoreJob.secrets;
            this.importOptions = restoreJob.importOptions;
            this.expireAt = restoreJob.expireAt;
            this.bucketCount = restoreJob.bucketCount;
            this.consistencyLevel = restoreJob.consistencyLevel;
            this.localDatacenter = restoreJob.localDatacenter;
            this.manager = restoreJob.restoreJobManager;
            this.sliceCount = restoreJob.sliceCount;
        }

        public Builder createdAt(LocalDate createdAt) {
            return (Builder)this.update(b -> {
                b.createdAt = createdAt;
            });
        }

        public Builder jobId(UUID jobId) {
            return (Builder)this.update(b -> {
                b.jobId = jobId;
            });
        }

        public Builder keyspace(String keyspace) {
            return (Builder)this.update(b -> {
                b.keyspaceName = keyspace;
            });
        }

        public Builder table(String table) {
            return (Builder)this.update(b -> {
                b.tableName = table;
            });
        }

        public Builder jobAgent(String jobAgent) {
            return (Builder)this.update(b -> {
                b.jobAgent = jobAgent;
            });
        }

        public Builder jobStatus(@NotNull RestoreJobStatus jobStatus) {
            return (Builder)this.update(b -> {
                b.status = jobStatus;
                b.statusText = jobStatus.name();
            });
        }

        public Builder jobStatusText(String statusText) {
            return (Builder)this.update(b -> {
                b.status = RestoreJob.decodeJobStatus(statusText);
                b.statusText = statusText;
            });
        }

        public Builder jobSecrets(RestoreJobSecrets jobSecrets) {
            return (Builder)this.update(b -> {
                b.secrets = jobSecrets;
            });
        }

        public Builder sstableImportOptions(SSTableImportOptions options) {
            return (Builder)this.update(b -> {
                b.importOptions = options;
            });
        }

        public Builder expireAt(Date expireAt) {
            return (Builder)this.update(b -> {
                b.expireAt = expireAt;
            });
        }

        public Builder sliceCount(Long sliceCount) {
            return (Builder)this.update(b -> {
                b.sliceCount = sliceCount;
            });
        }

        public Builder bucketCount(short bucketCount) {
            return (Builder)this.update(b -> {
                b.bucketCount = bucketCount;
            });
        }

        public Builder consistencyLevel(@Nullable ConsistencyLevel consistencyLevel) {
            return (Builder)this.update(b -> {
                b.consistencyLevel = consistencyLevel;
                b.manager = this.resolveJobManager();
            });
        }

        public Builder localDatacenter(@Nullable String localDatacenter) {
            return (Builder)this.update(b -> {
                b.localDatacenter = localDatacenter;
            });
        }

        public Builder shouldRestoreToLocalDatacenterOnly(boolean localDatacenterOnly) {
            return (Builder)this.update(b -> {
                b.shouldRestoreToLocalDatacenterOnly = localDatacenterOnly;
            });
        }

        public Builder self() {
            return this;
        }

        public RestoreJob build() {
            return new RestoreJob(this);
        }

        private Manager resolveJobManager() {
            return this.consistencyLevel == null ? Manager.SPARK : Manager.SIDECAR;
        }
    }
}

